// $Id: window.cc,v 1.43 2003/03/31 14:09:27 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
// AccelGroups really made it ugly

#include "window.hh"

static Gtk_Window Gtk_Window(false);

const std::string Gtk_Window::TypeName(const Widget &w) const
{  return GtkPrefix()+"Window";
}

const std::string Gtk_Window::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"window.h";
}

Gtk_Window::Gtk_Window(bool base_class_init)
{  if (!base_class_init) Writer["GtkWindow"]=this;
}

#if 0
void Gtk_Window::CInclude(const Widget &w,CxxFile &f) const
{  Parent::CInclude(w,f)
   if (Configuration.sample_code && !hasSignal("delete_event")) 
		f.Include(Configuration.GtkmmIncludePath()+"main.h");
}
#endif

void Gtk_Window::ConstructionArgs(const Widget &w, CxxFile &f) const
{  std::string type=w.getProperty("type","GTK_WINDOW_TOPLEVEL");
   f.FunctionArg(Gtkmm2Namespace(type));
}

bool Gtk_Window::NeedExplicitCtor(const Widget &w) const
{  return w.hasProperty("type");
}

void Gtk_Window::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   WriteTranslatableProperty(w,f,instance, "title");
   WriteIntIntProperty(w,f,instance, "default_width", "default_height", "default_size");
   WriteBoolProperty(w,f,instance, "modal");

   // or window_position ???
   WriteEnumPropertyNS(w,f,instance, "position");
   if (GTKMM2)
      WriteEnumPropertyNS(w,f,instance, "window_position", true);

#if 1
   // Compatibility cruft!
   if (w.hasProperty("allow_shrink") || 
   	w.hasProperty("allow_grow") ||
   	w.hasProperty("auto_shrink"))
   {  bool allow_shrink=w.getBoolProperty("allow_shrink",false);
      bool allow_grow=w.getBoolProperty("allow_grow",true);
      bool auto_shrink=w.getBoolProperty("auto_shrink",false);
      if (allow_shrink || !allow_grow || auto_shrink)
      {  if (GTKMM2)
         {  if (!allow_shrink && !allow_grow && auto_shrink)
               f.Statement() << instance << "set_resizable(false)";
            else
            {  std::cerr << w.Name() << ": non recommended window behaviour\n";
               WriteBoolProperty(w,f,instance, "allow_shrink", true);
               WriteBoolProperty(w,f,instance, "allow_grow", true);
//               WriteBoolProperty(w,f,instance, "auto_shrink", true);
            }
         }
         else
            f.Statement() << instance << "set_policy(" 
            	<< PRINT_BOOL(allow_shrink)
           	<< ", " << PRINT_BOOL(allow_grow)
           	<< ", " << PRINT_BOOL(auto_shrink) << ')';
      }
   }
#endif
   
   if (GTKMM2)
      WriteBoolProperty(w,f,instance, "resizable");

   if (w.getBoolProperty("modal",false))
      std::cerr << "To make your window modal you must also call set_transient_for()\n";

   if (Configuration.has_accelerators && GTKMM1)
      f.Statement() << instance << "add_accel_group(*(gmm_data->getAccelGroup()))";
   if (GTKMM2)
      WriteBoolProperty(w,f,instance, "destroy_with_parent", true);
}

#if 0
bool Gtk_Window::SampleCode(CxxFile &f,const Widget &w,enum WriterType::CodePosition pos,const std::string misc)
{  switch(pos)
   {  
#if 0
      case WriterType::ContainingConstructor: // not needed now ...
   	 break;
#endif
      case WriterType::Constructor:
         {  Widget::const_iterator i=w.get_Signals();
            for (;i!=w.end() && (*i).getProperty("name","")!="delete_event";++i);
            if (i==w.end())
            {  // 1.1: connect_to_method($1,$2,$3) => $1.connect(SigC::slot($2,$3))
               f << "\tconnect_to_method(destroy, " 
                 << GtkPrefix() << "Main::instance(), &"
                 << GtkPrefix() << "Main::quit);\n";
            }
   	 }
   	 break;
      default: break;
   }
   return false;
}
#endif

const Widget Gtk_Window::get_accelgroup(const Widget &w) const
{  static Tag accelgroup("widget");
   std::string name(Configuration.InstanceName(w.Name())+"_accgrp");
   if (Widget(accelgroup).Name()==name)
   {  return Widget(accelgroup);
   }
   accelgroup=createWidgetTag("GtkAccelGroup", name);
   Widget w2(accelgroup);
   w2.setProperty(CXX_IS_MANAGED);
   return w2;
}

void Gtk_Window::CreatePointer(const Widget &w,CxxFile &f) const
{  const bool never_reached(false);
   assert(never_reached);
}

void Gtk_Window::AdditionalMemberVars(const Widget &w,CxxFile &f,bool container) const
{  if (Configuration.has_accelerators)
   {  Widget w2(get_accelgroup(w));
      f.Private();
      LookupWriter(w2).GHDeclaration(w2,f);
      f.Declaration("GlademmData *gmm_data");
   }
   Parent::AdditionalMemberVars(w,f,container);
}

void Gtk_Window::DestroyPointer(const Widget &w,CxxFile &f) const
{  const bool never_reached(false);
   assert(never_reached);
}

void Gtk_Window::ApplyPreferences(Tag &t) const
{  Parent::ApplyPreferences(t);
   if (Configuration.has_accelerators)
   {  Widget w(&t);
      static bool did_warn;
      if (!did_warn && GTKMM1)
      {  did_warn=true;
         std::cerr << "WARNING: accelerators break code compatibility.\n";
      }
   }
}

void Gtk_Window::GCInclude(const Widget &w, CxxFile &f) const
{  if (Configuration.has_accelerators) // cheap assertion, doesn't hurt
   {  f.Include("gdk/gdkkeysyms.h");
      Widget w2(get_accelgroup(w));
      LookupWriter(w2).GCInclude(w2,f);
   }
}

void Gtk_Window::ClassConstructor(const Widget &w, CxxFile &f) const
{  Parent::ClassConstructor(w,f);
   if (Configuration.has_accelerators)
   {  if (GTKMM1)
      {  Widget w2(get_accelgroup(w));
         LookupWriter(w2).CreatePointer(w2,f);
         f.Statement("gmm_data").Assignment("new ").FunctionName("GlademmData")
      	   .FunctionArg(Pointer(w2));
      }
      else
      {  f.Statement("gmm_data").Assignment("new ").FunctionName("GlademmData")
      	   .FunctionArg("get_accel_group()");
      }
      f.EndLine();
   }
}

void Gtk_Window::ClassDestructor(const Widget &w, CxxFile &f) const
{  if (Configuration.has_accelerators)
   {  if (GTKMM1) 
      {  Widget w2(get_accelgroup(w));
         LookupWriter(w2).DestroyPointer(w2,f);
      }
      f.Statement("delete gmm_data").EndLine();
   }
   Parent::ClassDestructor(w,f);
}

