#ifndef INTERFACE_H
#define INTERFACE_H

#define LongRunDataTypeNum 4
typedef enum {
	LongRunData,
	FrequencyData,
	VoltageData,
	PercentageData,
} LongRunDataType;


#define GKrelLongRunPartsTypeNum 5
typedef enum {
        Mode,
        Frequency,
        Voltage,
        Meter,
	Slider,
} GKrelLongRunPartsType;

typedef struct {
        gint enable;
        GkrellmPanel *panel;
        GkrellmDecal *decal;
        gchar *label;
        GkrellmKrell *krell;
        GtkWidget *enable_button;
} GKrelLongRunParts;

typedef struct {
        gint enable;
	GkrellmChart *chart;
	GkrellmChartconfig *chart_config;
	gboolean draw_extra_info;
        GtkWidget *enable_button;
	gchar *text_format;
	GtkWidget *text_format_combo;
} GKrelLongRunChart;

struct _longrun_t {
	GkrellmMonitor *monitor;
        GKrelLongRunParts parts[GKrelLongRunPartsTypeNum];
	GKrelLongRunChart gkchart;
	gint data[LongRunDataTypeNum];
};
typedef struct _longrun_t longrun_t;

extern gchar *longrun_mode_label[];
extern GtkItemFactoryEntry gkrellongrun_factory_entry[];

extern longrun_t longrun;

extern int get_gkrellonrun_factory_size();

/* from if_*.c */
extern void set_longrun_label();
extern int check_cpu();
extern void read_longrun_data();

#endif /* INTERFACE_H */

