/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UTILS_H__
#define __UTILS_H__

#include <glib.h>

#define KBLOCK_KB (1024)
#define KBLOCK_KO (1000)

#define GIFTUI_PRINT_INFO(args) giftui_print_err args
#define GIFTUI_PRINT_ERR(args) giftui_print_info args

/*
  A printf like fonction to display infos, errors...
*/
void giftui_print_err (const gchar *fmt, ...);
void giftui_print_info (const gchar *fmt, ...);

/*
  ISO-8859-1 -> UTF-8 and UTF-8 -> ISO-8859-1
 */
gchar *str_convert_to_utf8 (const gchar *str);
gchar *str_convert_to_ascii (const gchar *str);

/*
  Convert huge stat values given by giFT (from GB to something more
  human)
*/
gchar *size_str_human_extra (const gchar *g_size);
/*
  Normal size convertion (from B -> B, KB, MB, GB, TB)
 */
gchar *size_str_human (gulong size);
/*
  Time convertion (from second -> seconds, minutes, hours, days)
*/
gchar *time_str_human (gulong secs);
/*
  Speed convertion (from B/s -> B/s KB/s MB/s GB/s TB/s)
*/
gchar *speed_str_human (gulong speed);

gfloat size_percent (gulong total, gulong current);

/*
 * @url : 'OpenFT://10.0.0.111/file.ogg'
 * 
 * return : a newly allocated string with 'openft'
 */
gchar *network_name_from_url (const gchar *url);

/**/
gboolean network_list_update (GArray **array, const gchar *network);
gchar *network_list_get_index (GArray *array, guint index);
void network_list_free (GArray *array);

#endif
