/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "main.h"

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "util.h"

#include "ui_icon.h"

#define ICON_MAX_LENGHT (64)

static GdkPixbuf *
icon_pixbuf (const gchar *name)
{
	gchar *file;
	GdkPixbuf *pixbuf = NULL;
	
	g_return_val_if_fail (name != NULL, NULL);
	
	if ((file = g_strdup_printf ("%s/icons/%s-network.png",
				     DATADIR, name)))
	{
		GError *error = NULL;
		
		pixbuf = gdk_pixbuf_new_from_file (file, &error);
		if (error)
		{
			GIFTUI_PRINT_ERR (("%s\n", error->message));
			g_error_free (error);
		}
		g_free (file);
	}
	
	return pixbuf;
}

gchar *
giftui_icon_stock (GiftuiIconType_t type, const gchar *network)
{
	gchar *stock_id;
	GtkStockItem item;
	
	g_return_val_if_fail (network != NULL, NULL);
	
	
	switch (type)
	{
	case ICON_NETWORK:
		stock_id = g_strdup_printf ("giftui-network-%s", network);
		break;
		
	case ICON_TRANSFER_DOWN:
		stock_id = g_strdup_printf ("giftui-transfer-up-%s", network);
		break;
		
	case ICON_TRANSFER_UP:
		stock_id = g_strdup_printf ("giftui-transfer-down-%s", network);
		break;
		
	default:
		stock_id = NULL;
		break;
	}
	
	if (stock_id && !gtk_stock_lookup (stock_id, &item))
	{
		GdkPixbuf *pixbuf;
		
		if ((pixbuf = icon_pixbuf (network)))
		{
			GtkIconSet *icon_set;
			GtkIconFactory *fact;
			
			icon_set = gtk_icon_set_new_from_pixbuf (pixbuf);
			fact = gtk_icon_factory_new ();
			gtk_icon_factory_add (fact, stock_id, icon_set);
			gtk_icon_factory_add_default (fact);
			
			g_object_unref (pixbuf);
		}
	}
	
	return stock_id;
}

gchar *
giftui_icon_case_stock (GiftuiIconType_t type, const gchar *network)
{
	gint i;
	gchar name[ICON_MAX_LENGHT];
	
	g_return_val_if_fail (network != NULL, NULL);
	
	i = 0;
	while (network[i] != '\0')
	{
		name[i] = g_ascii_tolower (network[i]);
		i++;
	}
	name[i] = '\0';
	
	return giftui_icon_stock (type, name);
}

GtkWidget *
giftui_icon_render_image (GtkWidget *widget, GiftuiIconType_t type,
			  const gchar *network, GtkIconSize size)
{
	gchar *stock_id;
	GtkWidget *image = NULL;
	
	if ((stock_id = giftui_icon_stock (type, network)))
	{
		image = gtk_image_new_from_stock (stock_id, GTK_ICON_SIZE_BUTTON);
		gtk_widget_show (image);
		
		g_free (stock_id);
	}
	    
	return image;
}

GtkWidget *
giftui_icon_case_render_image (GtkWidget *widget, GiftuiIconType_t type,
			       const gchar *network, GtkIconSize size)
{
	gint i;
	gchar name[ICON_MAX_LENGHT];
	
	g_return_val_if_fail (network != NULL, NULL);
	
	i = 0;
	while (network[i] != '\0')
	{
		name[i] = g_ascii_tolower (network[i]);
		i++;
	}
	name[i] = '\0';
	
	return giftui_icon_render_image (widget, type, name, size);
}
