/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_CONNECT_H__
#define __UI_CONNECT_H__

#include <gtk/gtk.h>

/* Warning : This is not a child of GiftuiChild_t ! */

#define GIFTUI_CONNECT(arg) ((GiftuiConnect_t *) (arg))

typedef struct _GiftuiConnect_t GiftuiConnect_t;

struct _GiftuiConnect_t
{
	GtkWidget *window;
	
	GtkWidget *host_entry;
	GtkWidget *port_spin;
	
	gchar *host;
	gint port;
	gboolean launch;
};

void giftui_connect (const gchar *host, gint port, gboolean launch);

void giftui_connect_create (const gchar *stock_id, const gchar *text,
			    const gchar *host, gint port, gboolean launch);

void giftui_connect_free (GiftuiConnect_t *con);

#endif
