// T3ERRUTIL.H : Handle simple error messages and Yes/No problems
//               using GNOME/GTK dialogue boxes.

// Copyright (C) 2000 Geoffrey Hutchison

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef T3ERRUTIL_H
#define T3ERRUTIL_H

#include "errutil.h"

/*################################################################################################*/

/**	The GNOME version of "##err_util".
	
	At the moment, these do not provide language localization but this class 
	would be an ideal place to provide this (e.g. through gettext()).
*/

class gnome_err_util : public err_util
{
	public:
	
	gnome_err_util(void);
	~gnome_err_util(void);
	
	void Message(const char *);		// virtual
	void WarningMessage(const char *);	// virtual
	void ErrorMessage(const char *);	// virtual
	
	bool Question(const char *);		// virtual
};

/*################################################################################################*/

#endif	// T3ERRUTIL_H

// eof
