// MM1TAB1.H : tables for the molecular mechanics force field.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM1TAB1_H
#define MM1TAB1_H

class exp1_tables;

/*################################################################################################*/

class mm1_mdl;			// mm1mdl.h
class mm1_typerule;		// mm1util.h

#include "mm1eng1.h"

#include <vector>
using namespace std;

/*################################################################################################*/

struct exp1_at		// atomtype
{
	i32s atomtype;
	mm1_typerule * typerule;
	char * description;
};

struct exp1_bs		// bond stretching
{
	i32s atmtp[2];
	bondtype bndtp;
	f64 param[2];
};

struct exp1_ab		// angle bending
{
	i32s atmtp[3];
	bondtype bndtp[2];
	f64 param[2];
};

struct exp1_tr		// torsion
{
	i32s atmtp[4];
	bondtype bndtp[3];
	f64 k; f64 s;
};

// out of plane...

struct exp1_lj		// lennard-jones
{
	i32s type;
	f64 r; f64 k;
};

struct exp1_ci		// charge increment
{
	i32s atmtp[2];
	bondtype bndtp;
	f64 delta;
};

/*################################################################################################*/

/// Molecular mechanics force field parameter tables.

class exp1_tables
{
	private:
	
	static exp1_tables * instance;
	
	vector<exp1_at> at_vector;
	
	vector<exp1_bs> bs_vector;
	vector<exp1_ab> ab_vector;
	vector<exp1_tr> tr_vector;
	vector<exp1_lj> lj_vector;
	vector<exp1_ci> ci_vector;
	
	private:
	
	exp1_tables(void);
	
	public:
	
	~exp1_tables(void);
	static exp1_tables * GetInstance(void);
	
	f64 GetChargeInc(mm1_bond *, ostream *);
	
	bool Init(mm1_eng *, mm1_exp1_bt1 *, i32s);
	bool Init(mm1_eng *, mm1_exp1_bt2 *, i32s *);
	bool Init(mm1_eng *, mm1_exp1_bt3 *, i32s *);
	
	bool Init(mm1_eng *, mm1_exp1_nbt1 *, bool);
	
	i32s UpdateTypes(mm1_mdl *);
	void PrintAllTypeRules(ostream &);
};

/*################################################################################################*/

#endif	// MM1TAB1_H

// eof
