with System;
with Ada.Unchecked_Conversion;
with GNAT.Table;

package body Str_Table is
   package String_Table is new GNAT.Table
     (Table_Index_Type => String_Id,
      Table_Component_Type => Character,
      Table_Low_Bound => Null_String + 1,
      Table_Initial => 4096,
      Table_Increment => 100);

   Nul : constant Character := Character'Val (0);

   In_String : Boolean := False;
   function Start return String_Id
   is
   begin
      pragma Assert (In_String = False);
      In_String := True;
      return String_Table.Last + 1;
   end Start;

   procedure Append (C : Character) is
   begin
      pragma Assert (In_String);
      String_Table.Append (C);
   end Append;

   procedure Finish is
   begin
      pragma Assert (In_String);
      String_Table.Append (Nul);
      In_String := False;
   end Finish;

   function Get_String_Fat_Acc (Id : String_Id) return String_Fat_Acc
   is
      function To_String_Fat_Acc is new Ada.Unchecked_Conversion
        (Source => System.Address, Target => String_Fat_Acc);
   begin
      return To_String_Fat_Acc (String_Table.Table (Id)'Address);
   end Get_String_Fat_Acc;

   function Get_Length (Id : String_Id) return Natural
   is
      Ptr : String_Fat_Acc;
      Len : Natural;
   begin
      Ptr := Get_String_Fat_Acc (Id);
      Len := 1;
      loop
         if Ptr (Len) = Nul then
            return Len - 1;
         end if;
         Len := Len + 1;
      end loop;
   end Get_Length;

   function Image (Id : String_Id) return String
   is
      Ptr : String_Fat_Acc;
      Len : Natural;
   begin
      Len := Get_Length (Id);
      Ptr := Get_String_Fat_Acc (Id);
      return Ptr (1 .. Len);
   end Image;
end Str_Table;
