#include <sys/times.h>
#include <unistd.h>

int
grt_get_clk_tck (void)
{
  return sysconf (_SC_CLK_TCK);
}

void
grt_get_times (int *wall, int *user, int *sys)
{
  clock_t res;
  struct tms buf;

  res = times (&buf);
  if (res == (clock_t)-1)
    {
      *wall = 0;
      *user = 0;
      *sys = 0;
    }
  else
    {
      *wall = res;
      *user = buf.tms_utime;
      *sys = buf.tms_stime;
    }
}

