/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  actionsignals.cc - Gtk::Action virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "action.hh"
#include "actionsignals.hh"
#include "private/actionclass.hh"
#include "widget.hh"

using namespace GFC;

/*  Gtk::ActionSignals
 */

Gtk::ActionSignals::ActionSignals(Action *action)
: G::ObjectSignals(action)
{
	Gtk::ActionClass::init(GTK_ACTION_GET_CLASS(action->gtk_action()));
}

Gtk::ActionSignals::~ActionSignals()
{
}

void
Gtk::ActionSignals::on_activate()
{
	GtkActionClass *g_class = ActionClass::get_parent_class(instance_);
	if (g_class->activate)
		g_class->activate((GtkAction*)instance_);
}

/*  Gtk::ActionClass
 */

void
Gtk::ActionClass::init(GtkActionClass *g_class)
{
	g_class->activate = &activate_proxy;
}

GtkActionClass*
Gtk::ActionClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_ACTION_GET_CLASS(instance));
	return static_cast<GtkActionClass*>(ptr);
}

GType
Gtk::ActionClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ACTION);
	}
	return type;
}

void*
Gtk::ActionClass::create(const char *name)
{
	return g_object_new(get_type(), "name", name, 0);
}

void
Gtk::ActionClass::activate_proxy(GtkAction *action)
{
	void *ptr = g_object_get_qdata((GObject*)action, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ActionSignals*>(ptr)->on_activate();
	else
	{
		GtkActionClass *g_class = ActionClass::get_parent_class(action);
		if (g_class->activate)
			g_class->activate(action);
	}
}

