/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  plugsignals.cc - Gtk::Plug virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "plug.hh"
#include "plugsignals.hh"
#include "private/plugclass.hh"

using namespace GFC;

/*  Gtk::PlugSignals
 */

Gtk::PlugSignals::PlugSignals(Plug *plug)
: WindowSignals(plug)
{
	Gtk::PlugClass::init(GTK_PLUG_GET_CLASS(plug->gtk_plug()));
}

Gtk::PlugSignals::~PlugSignals()
{
}

void
Gtk::PlugSignals::on_embedded()
{
	GtkPlugClass *g_class = PlugClass::get_parent_class(instance_);
	if (g_class->embedded)
		g_class->embedded((GtkPlug*)instance_);
}

/*  Gtk::PlugClass
 */

void
Gtk::PlugClass::init(GtkPlugClass *g_class)
{
	g_class->embedded = &embedded_proxy;
}

GtkPlugClass*
Gtk::PlugClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_PLUG_GET_CLASS(instance));
	return static_cast<GtkPlugClass*>(ptr);
}

GType
Gtk::PlugClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_PLUG);
	}
	return type;
}

void*
Gtk::PlugClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::PlugClass::embedded_proxy(GtkPlug *plug)
{
	void *ptr = g_object_get_qdata((GObject*)plug, G::ObjectSignals::quark());
	if (ptr)
		static_cast<PlugSignals*>(ptr)->on_embedded();
	else
	{
		GtkPlugClass *g_class = PlugClass::get_parent_class(plug);
		if (g_class->embedded)
			g_class->embedded(plug);
	}
}

