/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  table.cc - AtkTable C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "table.hh"
#include "private/marshal.hh"
#include "object.hh"
#include <gfc/glib/object.hh>

using namespace GFC;

/*  Atk::Table
 */

Atk::Table::Table()
{
}

Atk::Table::~Table()
{
}

Atk::Object*
Atk::Table::ref_at(int row, int column) const
{
	AtkObject *object = atk_table_ref_at(atk_table(), row, column);
	return object ? G::Object::wrap<Object>(object) : 0;
}

Atk::Object*
Atk::Table::get_caption() const
{
	AtkObject *object = atk_table_get_caption(atk_table());
	return object ? G::Object::wrap<Object>(object) : 0;
}

String
Atk::Table::get_column_description(int column) const
{
	return atk_table_get_column_description(atk_table(), column);
}

Atk::Object*
Atk::Table::get_column_header(int column) const
{
	AtkObject *object = atk_table_get_column_header(atk_table(), column);
	return object ? G::Object::wrap<Object>(object) : 0;
}

String
Atk::Table::get_row_description(int row) const
{
	return atk_table_get_row_description(atk_table(), row);
}

Atk::Object*
Atk::Table::get_row_header(int row) const
{
	AtkObject *object = atk_table_get_row_header(atk_table(), row);
	return object ? G::Object::wrap<Object>(object) : 0;
}

Atk::Object*
Atk::Table::get_summary() const
{
	AtkObject *object = atk_table_get_summary(atk_table());
	return object ? G::Object::wrap<Object>(object) : 0;
}

bool
Atk::Table::get_selected_columns(std::vector<int>& selected) const
{
	g_return_val_if_fail(selected.empty(), false);
	int *tmp_selected = 0;
	int n_columns = atk_table_get_selected_columns(atk_table(), &tmp_selected);

	int i = 0;
	while (i < n_columns)
	{
		selected.push_back(tmp_selected[i]);
		++i;
	}

	g_free(tmp_selected);
	return !selected.empty();
}

bool
Atk::Table::get_selected_rows(std::vector<int>& selected) const
{
	g_return_val_if_fail(selected.empty(), false);
	int *tmp_selected = 0;
	int n_rows = atk_table_get_selected_rows(atk_table(), &tmp_selected);

	int i = 0;
	while (i < n_rows)
	{
		selected.push_back(tmp_selected[i]);
		++i;
	}

	g_free(tmp_selected);
	return !selected.empty();
}

void
Atk::Table::set_caption(const Object *caption)
{
	atk_table_set_caption(atk_table(), *caption);
}

void
Atk::Table::set_column_description(int column, const String& description)
{
	atk_table_set_column_description(atk_table(), column, description.c_str());
}

void
Atk::Table::set_column_header(int column, const Object *header)
{
	atk_table_set_column_header(atk_table(), column, *header);
}

void
Atk::Table::set_row_description(int row, const String& description)
{
	atk_table_set_row_description(atk_table(), row, description.c_str());
}

void
Atk::Table::set_row_header(int row, const Object *header)
{
	atk_table_set_row_header(atk_table(), row, *header);
}

void
Atk::Table::set_summary(const Object *accessible)
{
	atk_table_set_summary(atk_table(), *accessible);
}

/*  Atk::Table signals
 */

const Atk::Table::RowInsertedSignalType Atk::Table::row_inserted_signal("row_inserted", (GCallback)&G::Marshal::void_int_int_callback);

const Atk::Table::ColumnInsertedSignalType Atk::Table::column_inserted_signal("column_inserted", (GCallback)&G::Marshal::void_int_int_callback);

const Atk::Table::RowDeletedSignalType Atk::Table::row_deleted_signal("row_deleted", (GCallback)&G::Marshal::void_int_int_callback);

const Atk::Table::ColumnDeletedSignalType Atk::Table::column_deleted_signal("column_deleted", (GCallback)&G::Marshal::void_int_int_callback);

const Atk::Table::RowReorderedSignalType Atk::Table::row_reordered_signal("row_reordered", (GCallback)&G::Marshal::void_callback);

const Atk::Table::ColumnReorderedSignalType Atk::Table::column_reordered_signal("column_reordered", (GCallback)&G::Marshal::void_callback);

const Atk::Table::ModelChangedSignalType Atk::Table::model_changed_signal("model_changed", (GCallback)&G::Marshal::void_callback);

