/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
*  Copyright (C) 2004 The GFC Development Team.
 *
 *  uimanager.inl - Gtk::UIManager inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkUIManager*
GFC::Gtk::UIManager::gtk_ui_manager() const
{
	return reinterpret_cast<GtkUIManager*>(instance_);
}

inline GFC::Gtk::UIManager::operator GtkUIManager* () const
{
	return this ? gtk_ui_manager() : 0;
}

inline bool 
GFC::Gtk::UIManager::get_add_tearoffs() const
{
	return gtk_ui_manager_get_add_tearoffs(gtk_ui_manager());
}

inline void 
GFC::Gtk::UIManager::set_add_tearoffs(bool add_tearoffs)
{
	gtk_ui_manager_set_add_tearoffs(gtk_ui_manager(), add_tearoffs);
}

inline const GFC::Gtk::UIManager::AddWidgetSignalProxy
GFC::Gtk::UIManager::sig_add_widget()
{
	return AddWidgetSignalProxy(this, &add_widget_signal);
}

	
inline const GFC::Gtk::UIManager::ActionsChangedSignalProxy
GFC::Gtk::UIManager::sig_actions_changed()
{
	return ActionsChangedSignalProxy(this, &actions_changed_signal);
}

inline const GFC::Gtk::UIManager::ConnectProxySignalProxy
GFC::Gtk::UIManager::sig_connect_proxy()
{
	return ConnectProxySignalProxy(this, &connect_proxy_signal);
}

inline const GFC::Gtk::UIManager::DisconnectProxySignalProxy
GFC::Gtk::UIManager::sig_disconnect_proxy()
{
	return DisconnectProxySignalProxy(this, &disconnect_proxy_signal);
}

inline const GFC::Gtk::UIManager::PreActivateSignalProxy
GFC::Gtk::UIManager::sig_pre_activate()
{
	return PreActivateSignalProxy(this, &pre_activate_signal);
}

inline const GFC::Gtk::UIManager::PostActivateSignalProxy
GFC::Gtk::UIManager::sig_post_activate()
{
	return PostActivateSignalProxy(this, &post_activate_signal);
}

