/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  item.inl - Gtk::Item inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkItem*
GFC::Gtk::Item::gtk_item() const
{
	return reinterpret_cast<GtkItem*>(instance_);
}

inline GFC::Gtk::Item::operator GtkItem* () const
{
	return this ? gtk_item() : 0;
}

inline void
GFC::Gtk::Item::select()
{
	gtk_item_select(gtk_item());
}

inline void
GFC::Gtk::Item::deselect()
{
	gtk_item_deselect(gtk_item());
}

inline void
GFC::Gtk::Item::toggle()
{
	gtk_item_toggle(gtk_item());
}

inline const GFC::Gtk::Item::SelectSignalProxy 
GFC::Gtk::Item::sig_select()
{
	return SelectSignalProxy(this, &select_signal);
}


inline const GFC::Gtk::Item::DeselectSignalProxy 
GFC::Gtk::Item::sig_deselect()
{
	return DeselectSignalProxy(this, &deselect_signal);
}

inline const GFC::Gtk::Item::ToggleSignalProxy 
GFC::Gtk::Item::sig_toggle()
{
	return ToggleSignalProxy(this, &toggle_signal);
}

