/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  object.inl - Atk::Object inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline AtkObject*
GFC::Atk::Object::atk_object() const
{
	return reinterpret_cast<AtkObject*>(instance_);
}

inline GFC::Atk::Object::operator AtkObject* () const
{
	return this ? atk_object() : 0;
}

inline int
GFC::Atk::Object::get_n_accessible_children() const
{
	return atk_object_get_n_accessible_children(atk_object());
}

inline GFC::Atk::Role
GFC::Atk::Object::get_role() const
{
	return (Role)atk_object_get_role(atk_object());
}

inline int
GFC::Atk::Object::get_index_in_parent() const
{
	return atk_object_get_index_in_parent(atk_object());
}

inline void
GFC::Atk::Object::set_name(const char *name)
{
	atk_object_set_name(atk_object(), name);
}

inline void
GFC::Atk::Object::set_description(const char *description)
{
	atk_object_set_description(atk_object(), description);
}

inline void
GFC::Atk::Object::set_role(Role role)
{
	atk_object_set_role(atk_object(), (AtkRole)role);
}

inline void
GFC::Atk::Object::notify_state_change(State state, bool value)
{
	atk_object_notify_state_change(atk_object(), state, value);
}

inline const GFC::Atk::Object::ChildrenChangedSignalProxy
GFC::Atk::Object::sig_children_changed()
{
	return ChildrenChangedSignalProxy(this, &children_changed_signal);
}

inline const GFC::Atk::Object::FocusEventSignalProxy
GFC::Atk::Object::sig_focus_event()
{
	return FocusEventSignalProxy(this, &focus_event_signal);
}

inline const GFC::Atk::Object::PropertyChangeSignalProxy
GFC::Atk::Object::sig_property_change()
{
	return PropertyChangeSignalProxy(this, &property_change_signal);
}

inline const GFC::Atk::Object::StateChangeSignalProxy
GFC::Atk::Object::sig_state_change()
{
	return StateChangeSignalProxy(this, &state_change_signal);
}

inline const GFC::Atk::Object::VisibleDataChangedSignalProxy
GFC::Atk::Object::sig_visible_data_changed()
{
	return VisibleDataChangedSignalProxy(this, &visible_data_changed_signal);
}

inline const GFC::Atk::Object::ActiveDescendantChangedSignalProxy
GFC::Atk::Object::sig_active_descendant_changed()
{
	return ActiveDescendantChangedSignalProxy(this, &active_descendant_changed_signal);
}

