/*
** 1998-10-15 -	Config page for main window position and size. Neat.
** 2000-02-26 -	This file has been pretty much entierly rewritten, and renamed. It now
**		supports configuring position and size of not only the main window, but
**		also the config and textview windows. Pretty neat.
*/

#include "gentoo.h"

#include "dialog.h"
#include "guiutil.h"
#include "strutil.h"

#include "cfg_module.h"
#include "cfg_windows.h"

#define	NODE	"Windows"

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	GtkWidget	*vbox;				/* Config page structures always begin like this. */
	GtkWidget	*content;			/* Content built for us by the window module. */
	GtkWidget	*dpos[2];			/* Dialog position mode radio buttons. */

	MainInfo	*min;
	gboolean	modified;
	WinInfo		*edit;				/* Window info being edited. */
	GtkWindowPosition dialog_pos;
} P_Windows;

static P_Windows	the_page;

/* ----------------------------------------------------------------------------------------- */

static void populate_page(P_Windows *page)
{
	if(page->content)
		gtk_widget_destroy(page->content);
	page->content = win_wininfo_build(page->edit, &page->modified);
	gtk_box_pack_start(GTK_BOX(page->vbox), page->content, FALSE, FALSE, 0);
	gtk_widget_show_all(page->content);
}

/* ----------------------------------------------------------------------------------------- */

static void evt_dialog_position_toggled(GtkWidget *wid, gpointer user)
{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wid)))
	{
		P_Windows	*page = user;
		gint		pos;

		pos = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(wid), "pos"));
		if(pos != page->dialog_pos)
		{
			page->dialog_pos = pos;
			page->modified = TRUE;
		}
	}
}

static GtkWidget * cwn_init(MainInfo *min, gchar **name)
{
	P_Windows	*page = &the_page;
	GtkWidget	*frame, *vbox;
	const gchar	*dlab[] = { N_("Dialog Windows Follow Mouse"), N_("Dialog Windows Center On Screen") };
	GtkWindowPosition	dpos[] = { GTK_WIN_POS_MOUSE, GTK_WIN_POS_CENTER };
	guint		i;
	GSList		*group = NULL;

	if(name == NULL)
		return NULL;

	*name = _("Windows");

	page->edit    = NULL;

	page->vbox    = gtk_vbox_new(FALSE, 0);
	page->content = NULL;

	frame = gtk_frame_new(_("Dialog Positioning"));
	vbox  = gtk_vbox_new(FALSE, 0);
	for(i = 0; i < sizeof dlab / sizeof *dlab; i++)
	{
		page->dpos[i] = gtk_radio_button_new_with_label(group, _(dlab[i]));
		gtk_object_set_data(GTK_OBJECT(page->dpos[i]), "pos", GINT_TO_POINTER(dpos[i]));
		gtk_signal_connect(GTK_OBJECT(page->dpos[i]), "toggled", GTK_SIGNAL_FUNC(evt_dialog_position_toggled), page);
		if(dpos[i] == min->cfg.dialogs.pos)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(page->dpos[i]), TRUE);
		group = gtk_radio_button_group(GTK_RADIO_BUTTON(page->dpos[i]));
		gtk_box_pack_start(GTK_BOX(vbox), page->dpos[i], FALSE, FALSE, 0);
	}
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_box_pack_end(GTK_BOX(page->vbox), frame, TRUE, FALSE, 5);

	gtk_widget_show_all(page->vbox);
	return page->vbox;
}

/* ----------------------------------------------------------------------------------------- */

/* 2000-01-30 -	Update possize display. */
static void cwn_update(MainInfo *min)
{
	P_Windows	*page = &the_page;

	page->min	= min;
	page->modified	= FALSE;

	if(page->edit != NULL)
		win_wininfo_destroy(page->edit);
	page->edit = win_wininfo_copy(min->cfg.wininfo);
	page->dialog_pos = min->cfg.dialogs.pos;
	populate_page(page);
}

/* ----------------------------------------------------------------------------------------- */

static void cwn_accept(MainInfo *min)
{
	P_Windows	*page = &the_page;

	if(page->modified)
	{
		win_wininfo_destroy(min->cfg.wininfo);
		min->cfg.wininfo = page->edit;
		min->cfg.dialogs.pos = page->dialog_pos;
		dlg_position_set(min->cfg.dialogs.pos);
		page->edit = NULL;
		page->modified = FALSE;
	}
}

/* ----------------------------------------------------------------------------------------- */

static gboolean cwn_save(MainInfo *min, FILE *out)
{
	win_wininfo_save(min->cfg.wininfo, out);

	return TRUE;
}

/* ----------------------------------------------------------------------------------------- */

static void cwn_load(MainInfo *min, const XmlNode *node)
{
	win_wininfo_load(min->cfg.wininfo, node);
}

/* ----------------------------------------------------------------------------------------- */

/* 2000-02-26 -	When the config window hides, we can free our editing copy if we (still) have one. */
static void cwn_hide(MainInfo *min)
{
	P_Windows	*page = &the_page;

	if(page->edit != NULL)
	{
		win_wininfo_destroy(page->edit);
		page->edit = NULL;
	}
}

/* ----------------------------------------------------------------------------------------- */

const CfgModule * cwn_describe(MainInfo *min)
{
	static const CfgModule	desc = { NODE, cwn_init, cwn_update, cwn_accept, cwn_save, cwn_load, cwn_hide };

	return &desc;
}
