/*
 * FILE: event_loop.c
 *
 */

#include "xplot_ext.h"

void
EventLoop(Frame *frame)
{
    XEvent          event;
    WindowData     *data;
    Graph          *graph;
    extern char    *CommandStr(void);
    Plot           *plot;
    extern char    *restorefile;

    XFlush(frame->display);
    graph = frame->graph;
    RescaleFrame(frame);

    /*
     * display the graph
     */

    AddLabelString((BasicWindow *)frame->text, "  ",
                   frame->text->fontwidth, frame->text->fontheight, 0.0, 0.0,
                   SCREEN_LBL, TEMPORARY_LBL);

    /*
     * execute command file or line if any
     */

    if (CommandStr())
    {
        if (CommandSource() == FROM_FILE)
        {
            plot = SelectedPlot(graph);
            DoFileCommands(graph, &plot, CommandStr());
        }
        else
        {
            plot = SelectedPlot(graph);
            DoCommand(graph, &plot, CommandStr());
        }
    }

    RescaleFrame(frame);

    MapWindows(frame);

    if (restorefile)
    {
        if (F->width > 0 && F->height > 0)
        {
            XResizeWindow(F->display, F->window, F->width, F->height);
            XFlush(frame->display);
            RescaleFrame(frame);
        }
    }

    while (1)
    {
        /*
         * remove all other expose events from the queue
         */

        XNextEvent(frame->display, &event);

        /*
         * get data from the window the event occured in
         */

        XFindContext(frame->display,
                     ((XKeyEvent *)(&event))->window,
                     datacontext,
                     (XPointer *)&data);

        if (debug)
        {
            fprintf(stderr, "window %s\n", data->parent->windowname);
        }

        ((int (*)(BasicWindow*, XEvent *))data->func)(data->parent, &event);
    }
}

void
frame_event(Frame *frame, XEvent *event)
{
    int stat;

    switch (event->type)
    {
    case ConfigureNotify:
        XSynchronize(frame->display, 1);
        stat = RescaleFrame(frame);
        XSynchronize(frame->display, 0);

        if (stat)
        {
            /*
             * get rid of the unpredictable refreshes generated by the
             * reconfigure
             */

            ZapExpose(frame->display);

            /*
             * refresh the subwindows myself
             */

            RefreshGraph(frame->graph);
            RefreshText(frame->text);
        }

        break;

    default:
        break;
    }
}


void
graph_event(Graph *graph, XEvent *event)
{
    XExposeEvent *xev;

    switch (event->type)
    {
    case Expose:
        xev = (XExposeEvent *) event;

        if (xev->count == 0)
        {
            RefreshGraph(graph);
        }

        break;

    case ButtonPress:
        ButtonPressAction(graph, (XButtonPressedEvent *)event);
        break;

    case ButtonRelease:
        ButtonReleaseAction(graph, (XButtonReleasedEvent *)event);
        break;

    case KeyPress:
        KeyAction(graph, (XKeyEvent *)event);
        break;

    case MotionNotify:
        PointerMotionAction(graph, (XPointerMovedEvent *)event);
        break;

    default:
        break;
    }
}


void
text_event(TextWindow *text, XEvent *event)
{
    XExposeEvent *xev;

    switch (event->type)
    {
    case Expose:
        xev = (XExposeEvent *) event;

        if (xev->count == 0)
        {
            RefreshText(text);
        }

        break;

    default:
        break;
    }
}


void
EventString(XEvent *E)
{
    XButtonPressedEvent *B;
    static int count = 0;

    printf("%d ", count);
    switch (E->type)
    {
    case ButtonPress:
        B = (XButtonPressedEvent *)E;
        printf("ButtonPress ");

        if (B->button == 1)
        {
            printf("1 ");
        }

        if (B->button == 2)
        {
            printf("2 ");
        }

        if (B->button == 3)
        {
            printf("3");
        }

        printf("\n");
        break;

    case ButtonRelease:
        B = (XButtonPressedEvent *)E;
        printf("ButtonRelease ");

        if (B->button == 1)
        {
            printf("1 ");
        }

        if (B->button == 2)
        {
            printf("2 ");
        }

        if (B->button == 3)
        {
            printf("3");
        }

        printf("\n");
        break;

    case MotionNotify:
        printf("PointerMoved %d %d\n",
               ((XPointerMovedEvent *)E)->state,
               ((XPointerMovedEvent *)E)->is_hint);
        break;

    case Expose:
        printf("Expose %d\n", ((XExposeEvent *)E)->count);
        break;

    case KeyPress:
        printf("KeyPress\n");
        break;

    case ConfigureNotify:
        printf("Configure\n");
        break;

    default:
        printf("unknown event type %d\n", E->type);
        break;
    }

    count++;
}
