#include "metric.h"

/*
 * This function is called only once by the gmond.  Use to 
 * initialize data structures, etc or just return SYNAPSE_SUCCESS;
 */
int
metric_init()
{
   return SYNAPSE_SUCCESS;
}

/*
 * 
 */

int
cpu_num_func ( int i )
{
   g_val_t val;

   val.s = 2;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
cpu_speed_func ( int i )
{
   g_val_t val;

   val.s = 500;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
mtu_func ( int i )
{
   g_val_t val;

   val.l = 0;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}


int
mem_total_func ( int i )
{
   g_val_t val;

   val.l = 512000;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
swap_total_func ( int i )
{
   g_val_t val;

   val.l = 512111;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
boottime_func ( int i )
{
   g_val_t val;

   val.l = 928272;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
sys_clock_func ( int i )
{
   g_val_t val;

   val.l = 94393292;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
kernel_func ( int i )
{
   g_val_t val;

   strncpy( val.str, "my kernel", MAX_G_STRING_SIZE );
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
cpu_user_func ( int i )
{
   g_val_t val;

   val.d = 89.9;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
cpu_nice_func ( int i )
{
   g_val_t val;

   val.d = 12.2;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int 
cpu_system_func ( int i )
{
   g_val_t val;

   val.d = 20.2;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int 
cpu_idle_func ( int i )
{
   g_val_t val;

   val.d = 12.4;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int 
cpu_aidle_func ( int i )
{
   g_val_t val;
   
   val.d = 50.00;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
load_one_func ( int i )
{
   g_val_t val;

   val.d = 20.00;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
load_five_func ( int i )
{
   g_val_t val;
 
   val.d = 10.23;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
load_fifteen_func ( int i )
{
   g_val_t val;

   val.d = 3.45;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
proc_run_func( int i )
{
   g_val_t val;

   val.l = 5;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
proc_total_func ( int i )
{
   g_val_t val;

   val.l = 120;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
mem_free_func ( int i )
{
   g_val_t val;

   val.l = 1223;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
mem_shared_func ( int i )
{
   g_val_t val;

   val.l = 512000;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
mem_buffers_func ( int i )
{
   g_val_t val;

   val.l = 34343;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
mem_cached_func ( int i )
{
   g_val_t val;

   val.l = 23232;
   set_metric_val(i, val);
   return SYNAPSE_SUCCESS;
}

int
swap_free_func ( int i )
{
   g_val_t val;

   val.l = 3409834;
   set_metric_val(i, val); 
   return SYNAPSE_SUCCESS;
}
