/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <nsIURI.h>

#include "galeon-embed-shell.h"
#include "GlobalHistory.h"
#include "GulString.h"

/**
 * class GlobalHistory: 
 *
 */

NS_IMPL_ISUPPORTS1(MozGlobalHistory, nsIGlobalHistory2)

MozGlobalHistory::MozGlobalHistory ()
{
	mGlobalHistory = galeon_embed_shell_get_global_history (embed_shell);
}

MozGlobalHistory::~MozGlobalHistory ()
{
}

/* void addURI (in nsIURI aURI, in boolean aRedirect, in boolean aToplevel); */
NS_IMETHODIMP MozGlobalHistory::AddURI (nsIURI *aURI,
					PRBool aRedirect,
					PRBool aTopLevel
#ifdef HAVE_NSIBROWSERHISTORY_ADDURI_WITH_REFERRER
					,nsIURI *aReferrer
#endif
					
					 )
{
	nsresult rv;
	NS_ENSURE_ARG_POINTER(aURI);

	/* Filter out unwanted URI's from the history,
	 * 
	 * We check the common cases first, then check against the banned
	 * list */

	PRBool isHTTP, isHTTPS;

	rv  = aURI->SchemeIs("http", &isHTTP);
	rv |= aURI->SchemeIs("https", &isHTTPS);
	NS_ENSURE_SUCCESS (rv, NS_ERROR_FAILURE);

	if (!isHTTP && !isHTTPS)
	{
		PRBool isAbout, isViewSource, isChrome, isData, isJavascript;

		rv  = aURI->SchemeIs("about", &isAbout);
		rv |= aURI->SchemeIs("view-source", &isViewSource);
		rv |= aURI->SchemeIs("chrome", &isChrome);
		rv |= aURI->SchemeIs("data", &isData);
		rv |= aURI->SchemeIs("javascript", &isJavascript);

		NS_ENSURE_SUCCESS(rv, NS_ERROR_FAILURE);

		if (isAbout || isViewSource || isChrome || isData || isJavascript)
		{
			return NS_OK;
		}
	}

	GulCString spec;
	rv = aURI->GetSpec(spec);
	NS_ENSURE_SUCCESS(rv, rv);

	global_history_visited (mGlobalHistory, spec.get());
	
	return NS_OK;
}

/* boolean isVisited (in string aURL); */
NS_IMETHODIMP MozGlobalHistory::IsVisited (nsIURI *aURI, PRBool *_retval)
{
	GulCString spec;
	aURI->GetSpec(spec);

	*_retval = global_history_is_visited (mGlobalHistory, spec.get());

	return NS_OK;
}

/* void setPageTitle (in string aURL, in wstring aTitle); */
NS_IMETHODIMP MozGlobalHistory::SetPageTitle (nsIURI *aURI, 
					      const nsAString& aTitle)
{
	GulCString spec;
	aURI->GetSpec(spec);

	global_history_set_page_title(mGlobalHistory, spec.get(),
				      GulCString (aTitle).get());

	return NS_OK;
}
