#  fsh - fast remote execution
#  Copyright (C) 2001 by Per Cederqvist.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

# Python 2.2 moved some constants from FCNTL to other modules, and
# dropped FD_CLOEXEC completely.  The relevant constants are now
# accessed via this module, that tries to get the constants as
# portably as possible.

import os
import fcntl

# O_NONBLOCK used to be present in FCNTL, but in Python 2.2 the only
# way to get it is via the os module.
try:
    O_NONBLOCK = os.O_NONBLOCK
except:
    import FCNTL
    O_NONBLOCK = FCNTL.O_NONBLOCK

# F_GETFD is present in FCNTL, but in Python 2.2 that module is
# deprecated, so we try to use fcntl instead.
try:
    F_GETFD = fcntl.F_GETFD
except:
    import FCNTL
    F_GETFD = FCNTL.F_GETFD

# F_SETFD is present in FCNTL, but in Python 2.2 that module is
# deprecated, so we try to use fcntl instead.
try:
    F_SETFD = fcntl.F_SETFD
except:
    import FCNTL
    F_SETFD = FCNTL.F_SETFD

# FD_CLOEXEC used to be present in FCNTL, but in Python 2.2 it isn't
# available at all!  I have reported the inability to find FD_CLOEXEC
# in Python 2.2 as a bug.  See <URL:http://sourceforge.net/tracker/
# ?func=detail&aid=496171&group_id=5470&atid=105470>.
try:
    # Stop Python 2.2 from warning that we import a deprecated module.
    # But Python 1.5.2 doesn't have the warnings module, so be prepared
    # for the import statement to fail.
    try:
        import warnings
        warnings.filterwarnings(
            "ignore",
            "the FCNTL module is deprecated; please use fcntl",
            DeprecationWarning)
    except ImportError:
        pass

    import FCNTL
    FD_CLOEXEC = FCNTL.FD_CLOEXEC

except AttributeError:

    # The value of FD_CLOEXEC is 1 on Solaris 8, HP-UX 11, Unicos 9.0,
    # Digital UNIX 4.0, SunOS 4.1.1_U1, IRIX 6.5, Linux 2.0 and Linux
    # 2.4 with glibc 2.2.3.  It is 1 even on AIX 4.2, so I guess it is
    # a fairly universal constant.

    FD_CLOEXEC = 1

    # If you find a system where the above definition of FD_CLOEXEC is
    # wrong, and where Python has been ported, please report it as a
    # bug to
    #
    #     http://bugzilla.lysator.liu.se/enter_bug.cgi?product=fsh
    #
    # Remember to state the operating system you are using (in the
    # format returned by os.uname()), and the proper value of
    # FD_CLOEXEC.
