#import "Globals.h"

#define kMusicDownloadURL @"http://freecraft.sourceforge.net/snapshots/music-pack-030109.tar.gz"
#define kMusicPackageName @"music-pack-030109.tar.gz"
#define kMusicPackageSize 21821510

@interface InstallerMusic : NSObject
{
	
	// The label and set of radio buttons associated with this segment of the installer
    IBOutlet id label;
    IBOutlet id radios;
	
	// The controller
	IBOutlet id controller;
	
	// Has the file necessary for installation already been downloaded?
	BOOL alreadyDownloaded;
	
}

// Called upon a change of selection by the user
- (IBAction)choiceChanged:(id)sender;

// Configures FreeCraft to use appropriate music
- (void)configure;

// Returns the path of where the file should be downloaded to
- (NSString *)destinationPath;

// Returns the URL for downloading the package or NULL if no download is necessary
- (NSURL *)downloadURL;

// Returns the expected size of the download or 0 if no download is necessary
- (int)downloadSize;

// Expands the music into FreeCraft
- (BOOL)expand;

// Called to prepare for installation
- (BOOL)prepare;

// Sets things up for the user
- (void)setup;

@end
