#import "InstallerFrameworks.h"

@implementation InstallerFrameworks

- (void)install
{
	// Create the Frameworks directory if it doesn't exist
	if (![fileManager fileExistsAtPath:@"/Library/Frameworks"])
		[fileManager createDirectoryAtPath:@"/Library/Frameworks" attributes:nil];
	
	// Check writability of Frameworks
	if ([fileManager isWritableFileAtPath:@"/Library/Frameworks"]) {
		
		// Copy in PNG.framework
		if (![fileManager fileExistsAtPath:@"/Library/Frameworks/PNG.framework"]) {
			[fileManager copyPath:[resourcesPath stringByAppendingString:@"PNG.framework"] toPath:@"/Library/Frameworks/PNG.framework" handler:NULL];
		}
		
		// Copy in OggVorbis.framework
		if (![fileManager fileExistsAtPath:@"/Library/Frameworks/OggVorbis.framework"]) {
			[fileManager copyPath:[resourcesPath stringByAppendingString:@"OggVorbis.framework"] toPath:@"/Library/Frameworks/OggVorbis.framework" handler:NULL];
		}

	}
	else {
		
		if (![fileManager fileExistsAtPath:@"/Library/Frameworks/PNG.framework"] ||
			![fileManager fileExistsAtPath:@"/Library/Frameworks/OggVorbis.framework"]) {
		
			// Complain that we don't have write access
			NSRunAlertPanel(@"Frameworks Cannot Be Installed", @"The Installer cannot install frameworks necessary for FreeCraft to function at \"/Library/Frameworks\". The frameworks will be moved to the desktop and must be installed by yourself at \"/Library/Frameworks\" before FreeCraft can be run.", @"Ok", NULL, NULL);
			
			// Move the frameworks to the desktop as we said we would
			if (![fileManager fileExistsAtPath:[NSHomeDirectory() stringByAppendingString:@"/Desktop/PNG.framework"]]) {
				[fileManager movePath:[resourcesPath stringByAppendingString:@"PNG.framework"] toPath:[NSHomeDirectory() stringByAppendingString:@"/Desktop/PNG.framework"] handler:NULL];
			}
			if (![fileManager fileExistsAtPath:[NSHomeDirectory() stringByAppendingString:@"/Desktop/OggVorbis.framework"]]) {
				[fileManager movePath:[resourcesPath stringByAppendingString:@"OggVorbis.framework"] toPath:[NSHomeDirectory() stringByAppendingString:@"/Desktop/OggVorbis.framework"] handler:NULL];
			}
					
		}

	}
}

@end
