#include <framerd/dtypes.h>
#include <stdio.h>

static char usage[]=
  "fdupdate <file> <file>\nfdupdate [files...] <directory>\n";

static void install_file(char *from,char *to)
{
  FILE *in=fd_fopen_locked(from,"r+b",0), *out;
  int  bufsize=65536*4, ret_value=0, bytes=0;
  char *buf=fd_xmalloc(bufsize), *realname=NULL;
  if (fd_symbolic_linkp(to)) {
    char *realsrc=fd_get_real_pathname(from);
    realname=fd_get_real_pathname(to);
    if (strcmp(realsrc,realname) == 0) {
      fd_warn("Not copying since %s is already linked to %s",to,from);
      fd_xfree(realsrc); fd_xfree(realname);
      return;}
    fd_warn("Copying %s to %s [linked from %s]",from,realname,to);
    out=fd_fopen_locked(realname,"wb",0);}
  else {
    fd_warn("Copying %s to %s",from,to);
    out=fd_fopen_locked(to,"wb",0);}
  if (errno) {perror("Start of binary copy"); FD_CLEAR_ERR();}
  if (in == NULL) 
    fd_raise_detailed_exception(fd_FileOpenFailed,from);
  else if (out == NULL) 
    fd_raise_detailed_exception(fd_FileOpenWFailed,to);
  else while ((ret_value=fread(buf,sizeof(char),bufsize,in)) ||
	      (!(feof(in)))) {
    bytes=bytes+ret_value; fwrite(buf,sizeof(char),ret_value,out);}
  fclose(out); fclose(in); free(buf);
  if (realname) fd_xfree(realname);
}

static int ends_in_slashp(char *string)
{
  int len=strlen(string);
  if (len == 0) return 0;
  else if (string[len-1] == '/') return 1;
  else return 0;
}

int main(int argc,char *argv[])
{
  if (argc < 2) {
    fputs(usage,stderr); exit(1);}
  else if ((argc > 3) && (!(fd_directoryp(argv[2])))) {
    fputs(usage,stderr); exit(1);}
  else if ((argc == 3) && (!(fd_directoryp(argv[2]))))
    install_file(argv[1],argv[2]);
  else {
    char *dirname=argv[2];
    int need_slashp=ends_in_slashp(dirname), dirlen=strlen(dirname);
    int n_files=argc-1, i=1; while (i < n_files) {
      char *base=fd_basename(argv[i],1);
      char *dest_path=fd_xmalloc(strlen(base)+dirlen+2);
      strcpy(dest_path,dirname);
      if (need_slashp) strcat(dest_path,"/");
      strcat(dest_path,base);
      install_file(argv[i],dest_path);
      fd_xfree(dest_path); i++;}}
  return 0;
}


