/* $Header: /home/yav/catty/fkiss/RCS/dir.c,v 1.14 2000/09/02 03:23:52 yav Exp $
 * Simple directory access routine
 * written by yav <yav@bigfoot.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * #define USE_BSD_DIRLIB 1
 *  use opendir, readdir and closedir library routines.
 * #define USE_BSD_DIRLIB 0
 *  use popen to execute "ls -af".
 *
 * #define DIR_STANDALONE_TEST
 * for self checking
 *
 */

char id_dir[] = "$Id: dir.c,v 1.14 2000/09/02 03:23:52 yav Exp $";

#include <stdio.h>

#ifdef DIR_STANDALONE_TEST
# include "config.h"
#else
# include <X11/Xlib.h>
# include "config.h"
# include "headers.h"
# include "fkiss.h"
# define PUBLIC_DIR_C
# include "extern.h"
#endif

#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif


#if HAVE_SYS_STAT_H
# include <sys/stat.h>
#else
# if HAVE_STAT_H
#  include <stat.h>
# endif
#endif

#ifdef DIR_STANDALONE_TEST
#define ks_malloc malloc
#define ks_realloc realloc
#define ks_strdup strdup
extern char *malloc();
extern char *realloc();
extern void free();
extern char *strdup();
extern char *strncpy();
#endif

#ifndef USE_BSD_DIRLIB
#warning USE_BSD_DIRLIB not defined!
#define USE_BSD_DIRLIB 0
#endif

#if !USE_BSD_DIRLIB
# ifndef MAXPATH
#  ifdef MAXPATHLEN
#   define MAXPATH MAXPATHLEN
#  else
#   define MAXPATH 1024
#  endif
# endif
#endif

/* free all allocated filename list */
void dir_free(list)
     char **list;
{
  char **p;
  
  if (list != NULL) {
    for (p = list; *p != NULL; p++)
      free(*p);
    free(list);
  }    
}

/* dir_ls - get filename list in directory
 * return filename pointer list (NULL : directory open error)
 */
char **dir_ls(path, func)
     char *path;		/* directory */
     int (*func)();		/* filename matching function (NULL:all) */
{
  int r;
  int i;
  char **list;
#if USE_BSD_DIRLIB
  DIR *dp;
  struct dirent *p;
#else
  FILE *fp;
#endif
  char *buf;
  char *subdir;
  struct stat st;
  char **sublist, **sublist0;
  char *ss;
  
  r = 0;
  list = NULL;
#if USE_BSD_DIRLIB
  if ((dp = opendir(path)) != NULL) {
    list = (char **)ks_malloc(sizeof(char *));
    while ((p = readdir(dp)) != NULL) {
      i = NAMLEN(p);
      buf = ks_malloc(i + 1);
      strncpy(buf, p->d_name, i);
      buf[i] = '\0';
      subdir = ks_malloc(strlen(path) + 1 + strlen(buf) + 1);
      sprintf(subdir, "%s/%s", path, buf);
      if (strcmp(buf, ".") && strcmp(buf, "..") &&
	  stat(subdir, &st) == 0 && (st.st_mode & S_IFDIR)) {
	sublist0 = sublist = dir_ls(subdir, func);
	if (sublist0 != NULL) {
	  while (*sublist) {
	    ss = ks_malloc(strlen(buf) + 1 + strlen(*sublist) + 1);
	    sprintf(ss, "%s/%s", buf, *sublist);
	    *(list+r++) = ss;
	    list = (char **)ks_realloc(list, sizeof(char *) * (r+1));
	    sublist++;
	  }
	  dir_free(sublist0);
	}
	free(buf);
      } else {
	if (func == NULL || (*func)(buf)) {
	  *(list+r++) = buf;
	  list = (char **)ks_realloc(list, sizeof(char *) * (r+1));
	} else {
	  free(buf);
	}
      }
      buf = NULL;
    }
    *(list+r) = NULL;
    closedir(dp);
  }
#else /* USE_BSD_DIRLIB */
  buf = ks_malloc(7 + strlen(path) + 1);
  sprintf(buf, "ls -af %s", path);
  if ((fp = popen(buf, "r")) != NULL) {
    list = (char **)ks_malloc(sizeof(char *));
    buf = ks_realloc(buf, MAXPATH);
    while (fgets(buf, MAXPATH, fp) != NULL) {
      i = strlen(buf) - 1;
      if (i >= 0 && buf[i] == '\n')
	buf[i] = '\0';		/* cut '\n' */
      subdir = ks_malloc(strlen(path) + 1 + strlen(buf) + 1);
      sprintf(subdir, "%s/%s", path, buf);
      if (strcmp(buf, ".") && strcmp(buf, "..") &&
	  stat(subdir, &st) == 0 && (st.st_mode & S_IFDIR)) {
	sublist0 = sublist = dir_ls(subdir, func);
	if (sublist0 != NULL) {
	  while (*sublist) {
	    ss = ks_malloc(strlen(buf) + 1 + strlen(*sublist) + 1);
	    sprintf(ss, "%s/%s", buf, *sublist);
	    *(list+r++) = ss;
	    list = (char **)ks_realloc(list, sizeof(char *) * (r+1));
	    sublist++;
	  }
	  dir_free(sublist0);
	}
      } else {
	if (func == NULL || (*func)(buf)) {
	  *(list+r++) = ks_strdup(buf);
	  list = (char **)ks_realloc(list, sizeof(char *) * (r+1));
	}
      }
    }
    free(buf);
    *(list+r) = NULL;
    pclose(fp);
  }
#endif /* USE_BSD_DIRLIB */
  return list;
}

#ifdef DIR_STANDALONE_TEST

int cmpfunc(char *name)
{
#if 0
  return (*name == 'f');
#else
  return 1;
#endif
}

int main(argc, argv)
     int argc;
     char **argv;
{
  int i;
  char **buf;
  
  if (argc < 2)
    exit(1);
#if USE_BSD_DIRLIB
  printf("* dir lib *\n");
#else
  printf("* dir ls  *\n");
#endif
  buf = dir_ls(*++argv, cmpfunc);
  if (buf == NULL) {
    fprintf(stderr, "``%s'' read error!\n", *argv);
    exit(1);
  }
  for (i = 0; *(buf+i) != NULL; i++) {
    printf("[%s]\n", *(buf+i));
  }
  dir_free(buf);
  printf("Total %d files\n", i);
  return 0;
}

#endif /* DIR_STANDALONE_TEST */

/* End of file */
