# ImageComp FilterProxy Module

# This module uses Image:magick to compress jpeg files so can be downloaded faster

package FilterProxy::ImageComp;

use strict;
no strict 'subs';
use Image::Magick;

use vars qw($VERSION $CONFIG);  # The $CONFIG variable MUST be exported.
                                # and should be a reference to a hash.
                                # keys to this hash are configuration
                                # variables, and values are used by this 
                                # module.

push @FilterProxy::MODULES,     # add myself to FilterProxy's list of known 
   "ImageComp";                  # modules
$VERSION = 0.01;
$CONFIG = {};                   # my $CONFIG.  This will be saved to and
                                # loaded from the config file by FilterProxy
                                # Module should define a basic CONFIG just in
                                # case this is the first time this module
                                # has ever been used.

$CONFIG->{order} = 4;           # must be a value in the range -10..10
                                # which specifies where in the chain of
                                # filters it wants to be executed.
                                # < 0: called before request is sent
                                # > 0: called after content is received
                                # -10    Outgoing header manglers
                                # -9..-1 Outgoing content manglers.
                                # -9..-7 May decode outgoing content.
                                # -6..-4 May modify outgoing content.
                                # -3..-1 May encode outgoing content.
                                # 0      not used
                                #  1..3: May decode incoming content
                                #  4..6: May modify incoming content
                                #  7..9: May encode incoming content
                                # 10: Must be called after all filters. 
                                #   (final header manipulation)
                                # This may also be an anonymous list ref if
                                # the module needs to be called more than once
                                # for a given request. (i.e. header mungers)
                                # 1-9 can expect content, 10 should not 
                                # depend on it.

$CONFIG->{mime_types} = [       # is a list of mime-types that this module
  "image/jpeg",                  # knows how to filter.  Can contain an empty
  "image/jpg",                 # string to specify all mime-types.
];

*logger = \&FilterProxy::logger;# Tells perl to use FilterProxy's logger function
                                # instead of looking for 
                                # FilterProxy::Skeleton::logger (this is because
                                # I'm lazy and don't want to type 
                                # FilterProxy::logger every time)
                                # Using this function will cause data to go to 
                                # FilterProxy's log file.

sub filter {                    # The main filtering routine.  Does the dirty work.
  my($req) = shift;             # $req is the HTTP::Request object 
  my($res) = shift;             # $res is the HTTP::Response object.  
  my($siteconfig) = shift;      # $siteconfig is a reference to a list of
                                # the site-specific configuration(s) for the
                                # site(s).  non site-specific config should 
                                # be in the
                                # $CONFIG variable (see above).

                                # Module must be able to handle it if any of 
                                # the above parameters are undef.
  if(defined $res) {
    # Save the file to disk to read and reduce
    open(Imgsave, ">/tmp/imagesave.jpg") || die "error opening imagesave.";
    print Imgsave ${$res->content_ref};
    close(Imgsave);

# Use Image magick to open the file 
     my($image,$compimage);
     $image = Image::Magick->new;
     $compimage = $image->Read('/tmp/imagesave.jpg');
     warn "$compimage" if "$compimage";
     
     # now you can do all sorts of this with the file like sample below change to greyscale
     # $image->Quantize(colorspace=>'gray');
     # this reduces the quality of the image to be 15
     
     $image->Set(quality=>15);
     $compimage = $image->Write('jpg:/tmp/imagesave2.jpg');
     warn "$compimage" if "$compimage";
     undef $image;

    #Open the files and write to a buffer to send as output
    open(Imgsave2, "/tmp/imagesave2.jpg") || die "error opening imagesave";
    my($tempImg,$a) = ("","");
    while ($a = <Imgsave2> ) { $tempImg = $tempImg.$a;}
    close(Imgsave2);
    
    # Send new image as output
  ${$res->content_ref} = $tempImg;
}

  logger(DEBUG, "FilterProxy::ImageComp::filter called.");
                                # $res->content_ref is an efficent way of
                                # accessing the document. (See HTTP::Message
                                # man page).
  return;                       # nothing needs to be returned.
}

sub Config {                    # parses the CGI parameters when the user
                                # modifies the configuration for this module.
                                # There should also be a .html file with the
                                # same name as the module, which contains the
                                # forms processed by this CGI.
  my($req, $cgi, $siteconfig) = @_;

  return "It worked.\n";        # a HTML-formatted message that will be 
                                # available to your .html file as $ENV{MESSAGE}
}

