case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

echo "Extracting doc/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#
# Variables
#	Variables established by Configure
CHMOD		=	$chmod
CP		=	$cp
DEST		=	\$(DESTDIR)$bin
ECHO		=	$echo
FORMATTER	=	$roff
FORMATTER_OPTS	=	$roffopts
LN		=	$ln
MAKE		=	$make
MAN		=	\$(DESTDIR)$mansrc
MANEXT		=	$manext
CATMAN		=	$catmansrc
CATMANEXT	=	$catmanext
RM		= 	$rm -f
TBL       	=	$tbl
MANROFF		=	$manroff
MANROFF_OPTS	=	$manroffopts
MV		=	$mv
TEST		=	$test
SUFFIX		=	$suffix
PACKED		=	$packed
PACKER		=	$packer
!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'

#	Other variables
SHELL		=	/bin/sh

# List of installed man pages 
MAN_LIST	=	$(MAN)/filter$(MANEXT)	

CATMAN_LIST	=	$(CATMAN)/filter$(CATMANEXT)$(SUFFIX)	

# List of formatted pages for catman
FORMATTED_PAGES_LIST =	catman/filter$(CATMANEXT)$(SUFFIX)

REMOTE_MAN_LIST	=	$(REMOTE)$(MAN)/filter$(MANEXT)	


# List of formatted guides
FORMATTED_LIST	=	Filter.fmtd

# Targets
all: 
	@if $(TEST) '$(CATMAN)' != none; then $(MAKE) $(MFLAGS) formatted_pages ;  else true ; fi

#	The following are no-ops
lint:
clean:	

formatted_pages: catman $(FORMATTED_PAGES_LIST)

catman:
	mkdir catman

install:
	@if $(TEST) '$(MAN)' != none; then $(MAKE) $(MFLAGS) install_man ; else true ;  fi
	@if $(TEST) '$(CATMAN)' != none; then $(MAKE) $(MFLAGS) install_catman ; else true ;  fi

install_man: $(MAN_LIST)

install_catman: $(CATMAN_LIST)

uninstall:
	@if $(TEST) '$(MAN)' != none; then  \
		$(RM) $(MAN_LIST)  ; \
	else \
		true ; \
	fi
	@if $(TEST) '$(CATMAN)' != none; then \
		$(RM) $(CATMAN_LIST) ; \
	else \
		true ; \
	fi

#	Dependencies and rules for installing man pages and lib files
#	taken from a remote system
#	This is the only target that gets installed even if not out-of-date
#	with respect the files from which it is installed.
rmt-install:	rmt-defined
		$(CP) $(REMOTE_MAN_LIST) $(MAN)
		$(CHMOD) u=rw,go=r $(MAN_LIST)

rmt-defined:
	@(if [ "$(REMOTE)" = "" ];\
	  then\
	    $(ECHO) "You need to define 'REMOTE' as the remote file system";\
	    $(ECHO) "for this particular command. The easiest way to do this";\
	    $(ECHO) "to type:";\
	    $(ECHO) "        make REMOTE=<remote file system> rmt-install";\
	    exit 1;\
	  fi);

#	Dependencies and rules for installing man pages and lib files

$(MAN)/filter$(MANEXT):	filter.1
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@


#	Dependencies and rules for installing catman
$(CATMAN)/filter$(CATMANEXT)$(SUFFIX): catman/filter$(CATMANEXT)$(SUFFIX)
				$(CP) $? $@
				$(CHMOD) u=rw,go=r $@


#	Dependencies and rules for making catman pages

catman/filter$(CATMANEXT)$(SUFFIX):		filter.1
	$(MANROFF) $(MANROFF_OPTS) -man $? > catman/filter$(CATMANEXT)
	@if $(TEST) "$(PACKED)" = y ; then \
		$(RM) $@ ; \
		$(PACKER) catman/filter$(CATMANEXT) ; \
	else \
		true ; \
	fi


#	Dependencies and rules for formatting guides
documentation:	$(FORMATTED_LIST)


Filter.fmtd:	Filter.guid
		$(TBL) $? | $(FORMATTER) $(FORMATTER_OPTS) tmac.n - > $@


!NO!SUBS!
