/*
 * fda.c - Free Debug Allocator
 * Copyright (C) 1997 Thomas Helvey <tomh@inxpress.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef FDA_H_INCLUDED__
#define FDA_H_INCLUDED__

#if defined(_DEBUG) || defined(DEBUG)
#ifdef NDEBUG
#undef NDEBUG
#endif
#ifndef FDA_HASH_TABLE_SIZE
#define FDA_HASH_TABLE_SIZE 16339 /* prime around 16K */
#endif
#if defined(_i386)
#define SHRED_BYTE 0xcd
#else
#define SHRED_BYTE 0xa3
#endif /* !_i386 */
#define SHRED_MEM(a,s)  memset((a), SHRED_BYTE, (s))

extern size_t fda_get_byte_count(void);
extern size_t fda_get_block_count(void);
extern size_t fda_sizeof(const void* p);
extern void   fda_clear_refs(void);
extern void   fda_set_ref(const void* p);
extern void   fda_assert_refs(void);
extern int    fda_enum_locations(void (*enumfn)(const char*, int, int));
extern int    fda_enum_leaks(void (*enumfn)(const char*, int, size_t, void*));
extern int    valid_ptr(const void* p, size_t size);

extern void* fda_malloc(size_t size, const char* file, int line);
extern void* fda_realloc(void* p, size_t size, const char* file, int line);
extern void* fda_calloc(size_t nelems, size_t size, const char* file, int line);
extern char* fda_dupstring(const char* src, const char* file, int line);
extern void  fda_free(void* p);

#define Malloc(s)     fda_malloc((s), __FILE__, __LINE__)
#define Realloc(p, s) fda_realloc((p), (s), __FILE__, __LINE__)
#define Calloc(n, s)  fda_calloc((n), (s), __FILE__, __LINE__)
#define DupString(s)  fda_dupstring((s), __FILE__, __LINE__)
#define Free(p)       fda_free((p))

#else /* !defined(_DEBUG) && !defined(DEBUG) */

extern void* Malloc(size_t size);
extern void* Realloc(void* p, size_t size);
extern void* Calloc(size_t nelems, size_t size);
extern char* DupString(const char* str);
#define      Free(p) free((p))

#endif /* !defined(_DEBUG && !defined(DEBUG) */

extern void set_lowmem_handler(void (*fn)(void));
extern void set_nomem_handler(void (*fn)(void));

#endif /* FDA_H_INCLUDED__ */
