/***************************************************************************
                          FLReportEngine.cpp  -  description
                             -------------------
    begin                : jue jun 27 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLReportEngine.h"
#include "FLSqlCursor.h"
#include "FLSqlQuery.h"
#include "FLGroupByQuery.h"

FLReportEngine::FLReportEngine ():MReportEngine ()
{
}

FLReportEngine::~FLReportEngine ()
{
  grandTotal.clear ();
}

void
FLReportEngine::addRowToReportData (FLSqlQuery * q, const int l)
{
  if (!q->isValid ())
	return;

  QDomElement row = rd.createElement ("Row");

  row.setAttribute ("level", l);
  int i = 0;

  for (QStringList::Iterator it = q->fieldList ()->begin (); it != q->fieldList ()->end (); ++it, i++)
	row.setAttribute ((*it), q->value (i).toString ());
  root_.appendChild (row);
}

void
FLReportEngine::groupBy (int level, int levelMax, FLSqlQuery * q, QString vA)
{
  if (level < 0)
	return;

  if (!q)
	return;

  if (!q->isValid ())
	return;

  addRowToReportData (q, level);
  FLSqlQuery::FLGroupByQueryDict * g = q->groupDict ();
  QString v = q->value ((*g)[QString::number (level)]->field ()).toString ();

  do
	{
	  if (v == q->value ((*g)[QString::number (level)]->field ()).toString ())
		{
		  if (level < levelMax - 1)
			groupBy (level + 1, levelMax, q, v);
		  else
			addRowToReportData (q, level + 1);
		}
	  else
		{
		  if (level == 0)
			groupBy (0, levelMax, q, QString::null);
		  else
			{
			  if (vA == q->value ((*g)[QString::number (level - 1)]->field ()).toString ())
				groupBy (level, levelMax, q, vA);
			  else
				groupBy (level - 1, levelMax, q, vA);
			}
		}
	}
  while (q->next ());
}

bool
FLReportEngine::setReportData (FLSqlQuery * q)
{
  if (!q)
	return false;

  root_ = rd.createElement ("KugarData");

  if (!q->exec ())
	{
	  qWarning ("FLReportEngine : " + tr (" No se ha podido ejecutar la consulta del informe"));
	  return false;
	}
  q->first ();

  FLSqlQuery::FLGroupByQueryDict * g = q->groupDict ();

  if (!g)
	{
		do
				addRowToReportData (q, 0);
  		while (q->next ());
	}
  else
	{
  		groupBy (0, g->count (), q, QString::null);
	}

  rd.appendChild (root_);

  initData ();

  return true;
}

bool
FLReportEngine::setReportData (FLSqlCursor * t)
{
  t = 0;
  qWarning ("No implementadio todava");
  return false;
}

bool
FLReportEngine::setFLReportTemplate (const QString & t)
{
  QFile fi (FLDATA "/facturalux/reports/" + t + ".kut");

  if (!fi.open (IO_ReadOnly))
	{
	  qWarning ("FLReportEngine : " + tr ("La plantilla para el informe ") + t + tr (" no est definida"));
	  return false;
	}

  QTextStream text (&fi);

  return setReportTemplate (text.read ());
}
