/***************************************************************************
                         mybarcode.h  -  description
                             -------------------
    begin                : Die Apr 23 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MY_BARCODE_H
#define MY_BARCODE_H

#include <qpixmap.h>
#include <string.h>
#include <ctype.h>
#include <qcstring.h>
#include <qfont.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qapplication.h>

class QColor;
class QString;

typedef struct barcodeData {
    QString value;
    int type; // GNU BARCODE internal type;
    int margin;
    double scale;
    bool text;
    QColor fg;
    QColor bg;
};

class FLCodBar {
    public:
        FLCodBar( QString value, int type, int margin, double scale, bool text_flag,
            QColor fg = Qt::black, QColor bg = Qt::white );
        FLCodBar( barcodeData* data );
        ~FLCodBar();

        QPixmap pixmap();
        int width();
        int height();

        bool isValid() {
            return valid;
        }

        static int convertType( QString type );
        static int index2type( int index );
        static int type2index( int type );
        static void fillDefault( barcodeData* data );
        static void print( barcodeData* data );

    private:
        void render(struct Barcode_Item* bci, bool text_flag = false,
                            QColor fg = Qt::black, QColor bg = Qt::white );
        void init( QString value, int type, int margin, double scale,
        bool text_flag, QColor fg, QColor bg );
        QPixmap p;
        bool valid;
};

#endif

