/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-perl.c,v 1.3 2003/11/24 20:04:20 hoa Exp $
 */

#include "etpan-perl.h"

struct etpan_perl * etpan_perl_new(XSINIT_t xs_init)
{
  struct etpan_perl * perl;

  perl = malloc(sizeof(* perl));
  if (perl == NULL)
    goto err;
  
  perl->interpreter = perl_alloc();
  if (perl->interpreter == NULL)
    goto free;
  
  perl_construct(perl->interpreter);
  
  perl->xs_init = xs_init;

  return perl;
  
 free:
  free(perl);
 err:
  return NULL;
}

void etpan_perl_call(struct etpan_perl * perl, char * filename)
{
  char *perl_args[] = { "", "-w", filename};
  
  perl_parse(perl->interpreter, perl->xs_init, 3, perl_args, NULL);
  perl_run(perl->interpreter);
}

void etpan_perl_free(struct etpan_perl * perl)
{
  perl_destruct(perl->interpreter);
  perl_free(perl->interpreter);
}
