#ifndef ETPAN_ABOOK_DRIVER_TYPES_H

#define ETPAN_ABOOK_DRIVER_TYPES_H

#include <libetpan/carray.h>

struct etpan_abook;

struct etpan_abook_driver {
  char * name;
  int (* connect)(struct etpan_abook * abook);
  int (* lookup)(struct etpan_abook * abook,
      const char * key, carray ** result);
  void (* uninitialize)(struct etpan_abook * abook);
};

struct etpan_abook {
  struct etpan_abook_driver * driver;
  void * data;
  int connected;
};

struct etpan_abook_entry {
  char * name;
  char * addr;
  char * nick;
};

#endif
