# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to configure the various view profiles.
"""

from qt import *
from ViewProfileForm import ViewProfileForm


class ViewProfileDialog(ViewProfileForm):
    """
    Class implementing a dialog to configure the various view profiles.
    """
    def __init__(self, profiles, separateShell, separateBrowser, parent = None):
        """
        Constructor
        
        @param profiles dictionary of tuples containing the visibility
            of the windows for the various profiles
        @param separateShell flag indicating that the Python shell 
            is a separate window
        @param separateBrowser flag indicating that the file browser
            is a separate window
        @param parent parent widget of this dialog (QWidget)
        """
        ViewProfileForm.__init__(self,parent,modal=1)
        
        dummy = self.trUtf8("Dummy")
        
        self.profiles = profiles
        
        # set the editor profile
        profile = self.profiles["edit"][0]
        self.eppbCheckBox.setChecked(profile[0])
        if separateBrowser:
            self.epfbCheckBox.setChecked(profile[1])
        else:
            self.epfbCheckBox.setChecked(0)
            self.epfbCheckBox.setEnabled(0)
        self.epdbCheckBox.setChecked(profile[2])
        if separateShell:
            self.eppsCheckBox.setChecked(profile[3])
        else:
            self.eppsCheckBox.setChecked(0)
            self.eppsCheckBox.setEnabled(0)
        self.eplvCheckBox.setChecked(profile[4])
        
        # set the debug profile
        profile = self.profiles["debug"][0]
        self.dppbCheckBox.setChecked(profile[0])
        if separateBrowser:
            self.dpfbCheckBox.setChecked(profile[1])
        else:
            self.dpfbCheckBox.setChecked(0)
            self.dpfbCheckBox.setEnabled(0)
        self.dpdbCheckBox.setChecked(profile[2])
        if separateShell:
            self.dppsCheckBox.setChecked(profile[3])
        else:
            self.dppsCheckBox.setChecked(0)
            self.dppsCheckBox.setEnabled(0)
        self.dplvCheckBox.setChecked(profile[4])
    
    def getProfiles(self):
        """
        Public method to retrieve the configured profiles.
        
        @return dictionary of tuples containing the visibility
            of the windows for the various profiles
        """
        profiles = {}
        
        # get the edit profile
        self.profiles["edit"][0] = [\
            self.eppbCheckBox.isChecked(),
            self.epfbCheckBox.isChecked(),
            self.epdbCheckBox.isChecked(),
            self.eppsCheckBox.isChecked(),
            self.eplvCheckBox.isChecked(),
        ]
        
        # get the debug profile
        self.profiles["debug"][0] = [\
            self.dppbCheckBox.isChecked(),
            self.dpfbCheckBox.isChecked(),
            self.dpdbCheckBox.isChecked(),
            self.dppsCheckBox.isChecked(),
            self.dplvCheckBox.isChecked(),
        ]
        
        return self.profiles
