/*
 * Copyright (C) 2003 Daniel Heck, Ralf Westram
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: help.cc,v 1.1 2003/04/11 13:32:50 reallysoft Exp $
 */

#include "enigma.hh"
#include "gui.hh"
#include "px/px.hh"
#include "help.hh"

using namespace enigma;
using namespace px;
using namespace std;

class HelpMenu : public gui::Menu {
public:
    HelpMenu(const char **helptext_, int xoffset);
private:
    bool on_event (const SDL_Event &e);
    void on_action(gui::Widget *w);
    void draw_background(px::GC &gc);

    const char  **helptext;
    int           xoffset;
    gui::Widget  *ok;
};


//----------------------------------------
// HelpMenu impl
//----------------------------------------
HelpMenu::HelpMenu(const char **helptext_, int xoffset_)
    : helptext(helptext_)
    , xoffset(xoffset_)
    , ok(new gui::TextButton("Ok", this))
{
    add(ok, Rect(640-170,480-60,150,40));
}

bool
HelpMenu::on_event (const SDL_Event &e)
{
    if (e.type == SDL_MOUSEBUTTONDOWN
        && e.button.button == SDL_BUTTON_RIGHT)
    {
        Menu::quit();
        return true;
    }
    return false;
}

void
HelpMenu::on_action(gui::Widget *w)
{
    if (w == ok)
        Menu::quit();
}

void
HelpMenu::draw_background(px::GC &gc)
{
    blit(gc, 0,0, enigma::GetImage("menu_bg"));
    Font *f = enigma::GetFont("menufont");

    int x     = 60;
    int x2    = x+ xoffset;     // 200;
    int y     = 60;
    int yskip = 30;

    for (int entry = 0; helptext[entry]; entry += 2, y += yskip) {
        f->render(gc, x,  y, helptext[entry]);
        f->render(gc, x2, y, helptext[entry+1]);
    }
}


void enigma::displayHelp(px::Screen *scr, const char **helptext, int xoffset) {
    HelpMenu(helptext, xoffset).manage(scr);
}

