#include <gtk/gtk.h>
#include "../animicon.h"

#include "av/av01.xpm"
#include "av/av02.xpm"
#include "av/av03.xpm"
#include "av/av04.xpm"
#include "av/av05.xpm"
#include "av/av06.xpm"
#include "av/av07.xpm"
#include "av/av08.xpm"
#include "av/av09.xpm"
#include "av/av10.xpm"
#include "av/av11.xpm"
#include "av/av12.xpm"
#include "av/av13.xpm"
#include "av/av14.xpm"
#include "av/av15.xpm"
#include "av/av16.xpm"
#include "av/av17.xpm"
#include "av/av18.xpm"
#include "av/av19.xpm"
#include "av/av20.xpm"
#include "av/av21.xpm"
#include "av/av22.xpm"


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


static void play_cb(GtkWidget *w, gpointer data)
{
	GtkWidget *a = GTK_WIDGET(data);
	AnimIconPlay(a);
}

static void pause_cb(GtkWidget *w, gpointer data)
{
	GtkWidget *a = GTK_WIDGET(data);
	AnimIconPause(a);
}

static void frame_next_cb(GtkWidget *w, gpointer data)
{
	GtkWidget *a = GTK_WIDGET(data);
	const gint	frame = AnimIconFrame(a),
			nframes = AnimIconFrames(a);

	if(frame < (nframes - 1))
	    AnimIconSeek(a, frame + 1);
}

static void frame_prev_cb(GtkWidget *w, gpointer data)
{
	GtkWidget *a = GTK_WIDGET(data);
	const gint	frame = AnimIconFrame(a);

	if(frame > 0)
	    AnimIconSeek(a, frame - 1);
}


int main(int argc, char *argv[])
{
	gboolean initialized_gtk = FALSE;
	gint i;
	const gchar *arg;
	GList *glist;
	GtkWidget *toplevel, *animicon, *w, *parent, *parent2;


	/* Parse arguments */
	for(i = 1; i < argc; i++)
	{
	    arg = argv[i];
	    if(arg == NULL)
		continue;

	    if(!g_strcasecmp(arg, "--help") ||
	       !g_strcasecmp(arg, "-help") ||
	       !g_strcasecmp(arg, "--h") ||
	       !g_strcasecmp(arg, "-h") ||
	       !g_strcasecmp(arg, "-?")
	    )
	    {
		g_print(
"Usage: %s\n",
		    argv[0]
		);
		return(0);
	    }
	}

	/* Initialize GTK as needed */
	if(!initialized_gtk)
	{
	    if(!gtk_init_check(&argc, &argv))
	    {
		g_printerr("Unable to initialize GTK.\n");
		return(1);
	    }
	    initialized_gtk = TRUE;

	    gdk_rgb_init();
	}


	/* Begin creating thumbs list */

	/* Toplevel */
	toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(gtk_main_quit), NULL
	);
	parent = w;

	w = gtk_vbox_new(FALSE, 5);
	gtk_container_border_width(GTK_CONTAINER(w), 5);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;


	/* Hbox & Frame for Animated Icon */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Frame for the Animated Icon */
	w = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Animated Icon */
	animicon = w = AnimIconNew(32, 32);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_widget_show(w);

	glist = NULL;
	glist = g_list_append(glist, av01_xpm);
	glist = g_list_append(glist, av02_xpm);
	glist = g_list_append(glist, av03_xpm);
	glist = g_list_append(glist, av04_xpm);
	glist = g_list_append(glist, av05_xpm);
	glist = g_list_append(glist, av06_xpm);
	glist = g_list_append(glist, av07_xpm);
	glist = g_list_append(glist, av08_xpm);
	glist = g_list_append(glist, av09_xpm);
	glist = g_list_append(glist, av10_xpm);
	glist = g_list_append(glist, av11_xpm);
	glist = g_list_append(glist, av12_xpm);
	glist = g_list_append(glist, av13_xpm);
	glist = g_list_append(glist, av14_xpm);
	glist = g_list_append(glist, av15_xpm);
	glist = g_list_append(glist, av16_xpm);
	glist = g_list_append(glist, av17_xpm);
	glist = g_list_append(glist, av18_xpm);
	glist = g_list_append(glist, av19_xpm);
	glist = g_list_append(glist, av20_xpm);
	glist = g_list_append(glist, av21_xpm);
	glist = g_list_append(glist, av22_xpm);
	AnimIconSetFromXPMDataList(w, glist, 150l);
	g_list_free(glist);

	AnimIconSetRepeating(w, TRUE);


	/* Hbox for buttons */
	w = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Play */
	w = gtk_button_new_with_label("Play");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(play_cb), animicon
	);
	gtk_widget_show(w);

	/* Pause */
	w = gtk_button_new_with_label("Pause");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(pause_cb), animicon
	);
	gtk_widget_show(w);      

	/* Prev */
	w = gtk_button_new_with_label("<<");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(frame_prev_cb), animicon
	);
	gtk_widget_show(w);      

	/* Next */
	w = gtk_button_new_with_label(">>");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(frame_next_cb), animicon
	);
	gtk_widget_show(w);      


	/* Show toplevel window */
	gtk_widget_show(toplevel);

	/* Start playing animation */
	AnimIconPlay(animicon);


	/* Enter GTK main loop */
	gtk_main();


	gtk_widget_destroy(animicon);
	gtk_widget_destroy(toplevel);


	return(0);
}
