#ifndef EDVPIXMAP_H
#define EDVPIXMAP_H

#include <gtk/gtk.h>


typedef struct _edv_pixmap		edv_pixmap;

/*
 *	Endeavour Pixmap:
 */
struct _edv_pixmap {

	GdkPixmap	*pixmap;
	GdkBitmap	*mask;
	gint		width,
			height;
	guint8		**data;		/* XPM data used to create
					 * pixmap (shared) */
	gchar		*name;		/* C Decl ID (taken from data) */
};
#define EDV_PIXMAP(p)	((edv_pixmap *)(p))


extern GList *EDVPixmapListNew(
        GList *glist,
        guint8 **data, const gchar *name,
        edv_pixmap **p_rtn   
);
extern GList *EDVPixmapListClean(GList *glist);

extern edv_pixmap *EDVPixmapListMatchByName(
	GList *glist, const gchar *name
);

extern edv_pixmap *EDVPixmapNew(guint8 **data, const gchar *name);
extern void EDVPixmapDelete(edv_pixmap *p);


#endif	/* EDVPIXMAP_H */
