/*
		   Endeavour Disk Object Creating

	See edvfop.h for standard disk object operations.
 */

#ifndef EDVFCREATE_H
#define EDVFCREATE_H

#include <gtk/gtk.h>
#include "endeavour.h"


extern const gchar *EDVFCreateGetError();

extern gint EDVFCreateFile(
	edv_core_struct *core_ptr,
	const gchar *path,
	gchar **new_obj_rtn,		/* Dynamically allocated */
	GtkWidget *toplevel,		/* Can be NULL */
	gboolean show_progress, gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVFCreateDirectory(
	edv_core_struct *core_ptr,
	const gchar *path,
	gchar **new_obj_rtn,		/* Dynamically allocated */
	GtkWidget *toplevel,		/* Can be NULL */
	gboolean show_progress, gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVFCreateLink(
	edv_core_struct *core_ptr,
	const gchar *path,
	gchar **new_obj_rtn,		/* Dynamically allocated */
	GtkWidget *toplevel,		/* Can be NULL */
	gboolean show_progress, gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVFCreateFifo(
	edv_core_struct *core_ptr,
	const gchar *path,
	gchar **new_obj_rtn,		/* Dynamically allocated */
	GtkWidget *toplevel,		/* Can be NULL */
	gboolean show_progress, gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVFCreateDeviceBlock(
	edv_core_struct *core_ptr,
	const gchar *path,
	gchar **new_obj_rtn,		/* Dynamically allocated */
	GtkWidget *toplevel,		/* Can be NULL */
	gboolean show_progress, gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVFCreateDeviceCharacter(
	edv_core_struct *core_ptr,
	const gchar *path,
	gchar **new_obj_rtn,		/* Dynamically allocated */
	GtkWidget *toplevel,		/* Can be NULL */
	gboolean show_progress, gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVFCreateSocket(
	edv_core_struct *core_ptr,
	const gchar *path,
	gchar **new_obj_rtn,		/* Dynamically allocated */
	GtkWidget *toplevel,		/* Can be NULL */
	gboolean show_progress, gboolean interactive,
	gboolean *yes_to_all
);


#endif	/* EDVFCREATE_H */
