/*
			     Desktop Icon
 */

#ifndef DESKICON_H
#define DESKICON_H

#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	Flags
 */
#define DESKICON_CAN_SELECT		(1 << 0)
#define DESKICON_CAN_MOVE		(1 << 1)
#define DESKICON_IS_MOVING		(1 << 2)
#define DESKICON_CAN_RENAME		(1 << 3)
#define DESKICON_ALWAYS_ON_TOP		(1 << 4)


/*
 *	Desktop icon structure:
 */
typedef struct {

	gboolean	initialized,
			map_state;

	gulong		flags;

	GdkGC		*gc;

	/* Icon widgets and resources */
	GtkWidget	*icon_toplevel,
			*icon_da;
	guint8		**last_icon_data;
	GdkPixmap	*icon_pixmap;
	GdkBitmap	*icon_mask;
	gint		icon_width,
			icon_height;

	/* Label widgets and resources */
	GtkWidget	*label_toplevel,
			*label_da;
	gchar		*label_str;
	gint		label_width,
			label_height,
			label_str_lbearing,	/* String extents */
			label_str_rbearing,
			label_str_width,
			label_str_ascent,
			label_str_descent;

	/* Menu */
	GtkWidget	*menu;

	/* Determines which button is currently held down */
	gint		button_down;

	/* Last pointer event relative to the root window */
	gint		last_x,
			last_y;

	/* Callbacks */

	/* Map referenced window, called on double-clicks */
	void		(*map_ref_cb)(
		gpointer,		/* Deskicon */
		gpointer		/* Data */
	);
	gpointer	map_ref_client_data;

	/* Select callback, called when deskicon is selected */
	void		(*select_cb)(
		gpointer,		/* Deskicon */
		gpointer		/* Data */
	);
	gpointer	select_client_data;

	/* Unselect callback, called when deskicon is unselected */
	void		(*unselect_cb)(
		gpointer,		/* Deskicon */
		gpointer		/* Data */
	);
	gpointer	unselect_client_data;

	/* Rename callback, called when deskicon label has changed */
	void		(*rename_cb)(
		gpointer,		/* Deskicon */
		const gchar *,		/* Old Name */
		const gchar *,		/* New Name */
		gpointer		/* Data */
	);
	gpointer	rename_client_data;

	/* Move begin callback, called at the beginning of any move */
	void		(*move_begin_cb)(
		gpointer,		/* Deskicon */
		gint, gint,		/* Position */
		gpointer		/* Data */
	);
	gpointer	move_begin_client_data;

	/* Moving callback, called during any movement */
	void		(*moving_cb)(
		gpointer,		/* Deskicon */
		gint, gint,		/* Position */
		gpointer		/* Data */
	);
	gpointer	moving_client_data;

	/* Moved callback, called after each move */
	void		(*moved_cb)(
		gpointer,		/* Deskicon */
		gint, gint,		/* Position */
		gpointer		/* Data */
	);
	gpointer	moved_client_data;

} deskicon_struct;
#define DESKICON(p)	((deskicon_struct *)(p))


#define DeskIconGetFlags(p)	(((p) != NULL) ? DESKICON(p)->flags : 0)
extern void DeskIconSetFlags(
	deskicon_struct *di, guint flags
);
extern void DeskIconUnsetFlags(
        deskicon_struct *di, guint flags
);

extern void DeskIconGetPosition(
	deskicon_struct *di, gint *x, gint *y
);
extern void DeskIconSetPosition(
	deskicon_struct *di, gint x, gint y
);

extern deskicon_struct *DeskIconNew(
	gint x, gint y,
	guint8 **icon_data, const gchar *label
);

extern void DeskIconSet(
	deskicon_struct *di,
	guint8 **icon_data, const gchar *label
);

extern gboolean DeskIconIsSensitive(deskicon_struct *di);
extern void DeskIconSetSensitive(deskicon_struct *di, gboolean sensitive);

extern gboolean DeskIconIsSelected(deskicon_struct *di);
extern void DeskIconSelect(deskicon_struct *di);
extern void DeskIconUnselect(deskicon_struct *di);

extern void DeskIconSetMapRefCB(
	deskicon_struct *di,
	void (*map_ref_cb)(gpointer, gpointer),
	gpointer client_data
);
extern void DeskIconSetSelectCB(
        deskicon_struct *di,
        void (*select_cb)(gpointer, gpointer),
        gpointer client_data
);
extern void DeskIconSetUnselectCB(
        deskicon_struct *di,
        void (*unselect_cb)(gpointer, gpointer),
        gpointer client_data
);
extern void DeskIconSetRenameCB(
        deskicon_struct *di,
        void (*rename_cb)(gpointer, const gchar *, const gchar *, gpointer),
        gpointer client_data
);
extern void DeskIconSetMoveBeginCB(
        deskicon_struct *di,
        void (*move_begin_cb)(gpointer, gint, gint, gpointer),
        gpointer client_data
);
extern void DeskIconSetMovingCB(
        deskicon_struct *di,
        void (*moving_cb)(gpointer, gint, gint, gpointer),
        gpointer client_data
);
extern void DeskIconSetMovedCB(
	deskicon_struct *di,
	void (*moved_cb)(gpointer, gint, gint, gpointer),
	gpointer client_data
);

extern void DeskIconSetMenu(deskicon_struct *di, GtkWidget *w);
extern GtkWidget *DeskIconGetMenu(deskicon_struct *di);

extern void DeskIconMap(deskicon_struct *di);
extern void DeskIconUnmap(deskicon_struct *di);

extern void DeskIconDelete(deskicon_struct *di);


#endif	/* DESKICON_H */
