#ifndef __ASK_H__
#define __ASK_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "rstring.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

typedef struct ask {
        int        cd;
        rstring_t *items;       /* names of items */
        int        selected;    /* index of selected item */
} ask_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern ask_t *ask_select (const char *name);
extern ask_t *ask_select_default (const char *name);
extern ask_t *ask_select_next (ask_t *ask);
extern void   ask_select_different (ask_t *ask);
extern char  *ask_get_field (ask_t *ask, const char *name);
extern int    ask_get_field_int_default (ask_t *ask, const char *f, int def);
extern int    ask_get_field_int (ask_t *ask, const char *field);
extern void   ask_change_where (ask_t *ask, const char *field,
                                const char *desired);
extern void   ask_destroy (ask_t *ask);

extern char *ask_for_default (const char *name, const char *field);
extern int   ask_for_default_int (const char *name, const char *field, int d);
extern char *ask_for_simple (const char *name);
extern int   ask_if_sure (char *question);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER ask.h
 *
 ****************************************************************************/
#endif
