#ifndef PDL_GEN_H
#define PDL_GEN_H

#include "deftbl.h"

#ifdef ELI_ARG
#undef ELI_ARG
#endif

#if defined(__STDC__) || defined(__cplusplus)
#define ELI_ARG(proto)    proto
#else
#define ELI_ARG(proto)    ()
#endif

#include "ptg_ana.h"
#include "Strings.h"
#include "keyarray.h"

#define TYPE ComponentKind
extern TYPE GetComponentKind ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void SetComponentKind ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void ResetComponentKind ELI_ARG((int _Property, DefTableKey key, TYPE _val));
#undef TYPE
#define TYPE int
extern TYPE Getint ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void Setint ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void Resetint ELI_ARG((int _Property, DefTableKey key, TYPE _val));
extern void Orint ELI_ARG((int _Property, DefTableKey key, TYPE val));
#undef TYPE
#define TYPE NodeType
extern TYPE GetNodeType ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void SetNodeType ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void ResetNodeType ELI_ARG((int _Property, DefTableKey key, TYPE _val));
#undef TYPE
#define TYPE CharPtr
extern TYPE GetCharPtr ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void SetCharPtr ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void ResetCharPtr ELI_ARG((int _Property, DefTableKey key, TYPE _val));
#undef TYPE
#define TYPE KeyArray
extern TYPE GetKeyArray ELI_ARG((int _Property, DefTableKey key, TYPE deflt));
extern void SetKeyArray ELI_ARG((int _Property, DefTableKey key, TYPE _add, TYPE _replace));
extern void ResetKeyArray ELI_ARG((int _Property, DefTableKey key, TYPE _val));
#undef TYPE

#define SetKind(key, _add, _replace)   \
		SetComponentKind(1, (key), (_add), (_replace))
#define ResetKind(key, _val)   \
		ResetComponentKind(1, (key), (_val))
#define GetKind(key, deflt)   \
		GetComponentKind(1, (key), (deflt))
#define SetOptional(key, _add, _replace)   \
		Setint(2, (key), (_add), (_replace))
#define ResetOptional(key, _val)   \
		Resetint(2, (key), (_val))
#define GetOptional(key, deflt)   \
		Getint(2, (key), (deflt))
#define SetIndex(key, _add, _replace)   \
		Setint(3, (key), (_add), (_replace))
#define ResetIndex(key, _val)   \
		Resetint(3, (key), (_val))
#define GetIndex(key, deflt)   \
		Getint(3, (key), (deflt))
#define SetType(key, _add, _replace)   \
		SetNodeType(4, (key), (_add), (_replace))
#define ResetType(key, _val)   \
		ResetNodeType(4, (key), (_val))
#define GetType(key, deflt)   \
		GetNodeType(4, (key), (deflt))
#define SetString(key, _add, _replace)   \
		SetCharPtr(5, (key), (_add), (_replace))
#define ResetString(key, _val)   \
		ResetCharPtr(5, (key), (_val))
#define GetString(key, deflt)   \
		GetCharPtr(5, (key), (deflt))
#define SetFunctionSym(key, _add, _replace)   \
		Setint(6, (key), (_add), (_replace))
#define ResetFunctionSym(key, _val)   \
		Resetint(6, (key), (_val))
#define GetFunctionSym(key, deflt)   \
		Getint(6, (key), (deflt))
#define SetArguments(key, _add, _replace)   \
		SetKeyArray(7, (key), (_add), (_replace))
#define ResetArguments(key, _val)   \
		ResetKeyArray(7, (key), (_val))
#define GetArguments(key, deflt)   \
		GetKeyArray(7, (key), (deflt))
#define OrInconsistentUse(key, val)   \
		Orint(8, (key), (val))
#define SetInconsistentUse(key, _add, _replace)   \
		Setint(8, (key), (_add), (_replace))
#define ResetInconsistentUse(key, _val)   \
		Resetint(8, (key), (_val))
#define GetInconsistentUse(key, deflt)   \
		Getint(8, (key), (deflt))
#define SetInserted(key, _add, _replace)   \
		Setint(9, (key), (_add), (_replace))
#define ResetInserted(key, _val)   \
		Resetint(9, (key), (_val))
#define GetInserted(key, deflt)   \
		Getint(9, (key), (deflt))
#define SetPrototypeComputed(key, _add, _replace)   \
		Setint(10, (key), (_add), (_replace))
#define ResetPrototypeComputed(key, _val)   \
		Resetint(10, (key), (_val))
#define GetPrototypeComputed(key, deflt)   \
		Getint(10, (key), (deflt))
#define SetClpValue(key, _add, _replace)   \
		Setint(11, (key), (_add), (_replace))
#define ResetClpValue(key, _val)   \
		Resetint(11, (key), (_val))
#define GetClpValue(key, deflt)   \
		Getint(11, (key), (deflt))

extern struct PropList PDLk[];


extern DefTableKey CloneKey ELI_ARG((DefTableKey key));
/* Clone a definition
 *    On entry-
 *       key=a valid definition
 *    On exit-
 *       CloneKey=Unique definition with the same properties
 *                and property values as key
 ***/

#ifdef MONITOR
extern void pdl_mon_properties ELI_ARG((DefTableKey));
#endif

#endif
