#! /bin/sh
# $Id: pgsInfo.sh,v 2.9 2004/03/09 17:24:44 waite Exp $
# Copyright 1989, The Regents of the University of Colorado

# This file is part of the Eli translator construction system.

# Eli is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.

# Eli is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

# You should have received a copy of the GNU General Public License along
# with Eli; see the file COPYING.  If not, write to the Free Software
# Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

# EXEC (pgsInfo.sh) (:Pgram) (:BuPgram) (+monitor)
#      (eingabe.exe) (analyse.exe)
#   => (:pgsInfo);

ODIN_Pgram=$1;shift; ODIN_BuPgram=$1;shift; ODIN_monitor=$1;shift;
ODIN_eingabe=$1;shift; ODIN_analyse=$1;shift;

SED=$ODINCACHE/PKGS/skeleton/sed.exe

if test '' = "$ODIN_monitor"
then echo 'AOUZ' > Optionen
else echo 'ACOUZ' > Optionen
fi

if test -s "$ODIN_BuPgram"
then
  input=$ODIN_BuPgram
  cp $ODIN_BuPgram Eindat
else
  input=$ODIN_Pgram
  cp $ODIN_Pgram Eindat
fi

echo NONAME | cat Optionen - | $ODIN_eingabe

$SED -e '/^#$/d
  /\* Error/s;^ *\([0-9]*\).*\*;'"$input"' 0 0;' Fehlerda \
  > ERRORS
if test -s ERRORS
then exit 0
fi

mv Putout eingabe.out

if $ODIN_analyse
then
  mv Putout analyse.out

  if test -s "$ODIN_BuPgram"
  then
    # Check to see if the non-bottomup version is also not LALR(1)
    rm -f Eindat
    cp $ODIN_Pgram Eindat
    echo NONAME | cat Optionen - | $ODIN_eingabe
    if $ODIN_analyse
    then cat eingabe.out analyse.out > pgsInfo
    else
      cat <<END > pgsInfo
BOTTOMUP constraints in your attribute grammar cause your concrete syntax to
be non-LALR(1).  Derive to :BottomUp to get the list of rules that have
BOTTOMUP constraints.

END
      cat eingabe.out analyse.out >> pgsInfo
    fi
  else cat eingabe.out analyse.out > pgsInfo
  fi
else
  $SED -n -e '/\* Error /s;^[^:]*:;'"$input"' 0 0;w ERRORS' Putout
  cat eingabe.out Putout > pgsInfo
fi
