/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "Syntax.h"
#include "Bool.h"
#include "GlobDef.h"
#include "AttrDefs.h"
#include "pdl_gen.h"
#include "csm.h"
#include "SymInh.h"

#include "LIGA.h"
#include "LIGAMacros.h"
#include "lookup_idl.h"
#include "ligaconsts.h"
#include "msgtxt.h"

/* access to csm module */
#define GetStringRef(s) (strng[s])

void PutSymClass (AtAppl, SymKey, GramKey)
	int	AtAppl;
	DefTableKey	SymKey, GramKey;
{	int	IsDef, IsAppl, Did, RootDid;

if (AtAppl) {
	IsDef = GetIsDefined (SymKey, false);
	if (!IsDef) SetSymClass (SymKey, SYMBTERM, SYMBTERM);
} else {
	SetSymClass (SymKey, SYMBNONT, SYMBNONT);
	IsAppl = GetIsApplied (SymKey, false);
	if (!IsAppl) {
		Did =  GetDid (SymKey, DIDNON);
		SetIsRoot (SymKey, true, true);
		EnterInherit (SymKey, ROOTCLASSKey, (POSITION*)0);
		RootDid = GetRootDid (GramKey, DIDNON);
		if (RootDid != MANYROOTS) {
		if (RootDid == DIDNON) 
			SetRootDid (GramKey, Did, Did);
		else
		if (RootDid != Did) 
			SetRootDid (GramKey, MANYROOTS, MANYROOTS);
		}
	}
}
}/*PutSymClass*/

ProdElem MakeProdElem (IsSymbol, Id, SyntKey, SyntPos, Coord)
	int		IsSymbol, Id, SyntPos;
	DefTableKey	SyntKey;
	POSITION *	Coord;
{	ProdElem	res;
res = (ProdElem) malloc (sizeof (_PElem));
res->IsSymbol = IsSymbol;
res->Id = Id;
res->Key = SyntKey;
res->SyntPos = SyntPos;
res->Coord = Coord;
return (res);
}/*MakeProdElem*/

void SetHEADTAILpos (rulekey)
	DefTableKey	rulekey;
{	TList		rhs;
	ProdElem	el;
	int		HEADpos, TAILpos;

rhs = TailList (GetRuleProd (rulekey, NullList));
HEADpos = 1000;
TAILpos = 0;
while (rhs != NullList) {
	el = (ProdElem) HeadList (rhs);
	if (el->IsSymbol) {
		if (SYMBNONT == GetSymClass (el->Key, SYMBTERM)) {
			if (el->SyntPos < HEADpos) HEADpos = el->SyntPos;
			if (el->SyntPos > TAILpos) TAILpos = el->SyntPos;
		}
	}
	rhs = TailList (rhs);
}
if (TAILpos == 0) HEADpos = 0;
SetHEADpos (rulekey, HEADpos, HEADpos);
SetTAILpos (rulekey, TAILpos, TAILpos);
}/*SetHEADTAILpos*/

void NewListProds (listkey, listrulekey, env, coord)
	DefTableKey	listkey, listrulekey;
	Environment	env;
	POSITION	*coord;
{	DefTableKey	rulekey;
	int		ruleid;
	TList		prod;
	int		listruleid;
	int		ldid;

listruleid = GetIdent (listrulekey, 0);
ldid = GetDid (listkey, DIDNON);

/* RULE ruleid: lhsid ::= END; */

ruleid = NewRuleId (0, listruleid, 0);
rulekey = Declare (env, ruleid, RuleDef, NoEnv, coord);
prod = ConsList (
	MakeProdElem (true, ldid, listkey, 0, coord),
	NullList);
SetRuleProd (rulekey, prod, prod);
SetHEADpos (rulekey, 0, 0);
SetTAILpos (rulekey, 0, 0);
SetListBase (rulekey, listrulekey, listrulekey);
SetListProdLg (rulekey, 0, 0);

/* RULE ruleid: lhsid ::= lhsid lhsid END; removed */

}/*NewListProds*/

DefTableKey NewElemProd (listrulekey, listkey, elkey, env, coord)
	DefTableKey	listrulekey, listkey, elkey;
	Environment	env;
	POSITION	*coord;
{	DefTableKey	rulekey;
	int		ruleid, listruleid;
	TList		prod;
	int		listdid;
	int		elid;

listruleid = GetIdent (listrulekey, 0);
elid = GetIdent (elkey, 0);
ruleid = NewRuleId (1, listruleid, elid);
rulekey = Declare (env, ruleid, RuleDef, NoEnv, coord);
listdid = GetDid (listkey, DIDNON);
prod = ConsList (MakeProdElem (true, listdid, listkey, 0, coord),
	ConsList (MakeProdElem (true, GetDid (elkey, DIDNON), elkey, 2, coord),
	ConsList (MakeProdElem (true, listdid, listkey, 1, coord),
		NullList)));
SetRuleProd (rulekey, prod, prod);
if (SYMBNONT == GetSymClass (elkey, SYMBTERM)) {
	SetHEADpos (rulekey, 2, 2);
	SetTAILpos (rulekey, 2, 2);
} else {
	SetHEADpos (rulekey, 1, 1);
	SetTAILpos (rulekey, 1, 1);
}
SetListBase (rulekey, listrulekey, listrulekey);
SetListProdLg (rulekey, 2, 2);
return (rulekey);
}/*NewElemProd*/


int DifferentProds (p1, p2)
	TList		p1, p2;
{	ProdElem	e1, e2;
if (p1 == p2) 	return (false);
if ((p1 == NullList) || (p2 == NullList)) 
		return (true);
e1 = (ProdElem) HeadList (p1);
e2 = (ProdElem) HeadList (p2);
if (e1->IsSymbol  && e2->IsSymbol) {
	if (e1->Id == e2->Id)
		return (DifferentProds (TailList (p1), TailList (p2)));
	else	return (true);
}
if (!(e1->IsSymbol) && !(e2->IsSymbol)) {
	if (strcmp(GetStringRef(e1->Id), GetStringRef(e2->Id)) == 0)
		return (DifferentProds (TailList (p1), TailList (p2)));
	else 	return (true);
}
return (true);
}/*DifferentProds*/

static DefTableKey rulechain = NoKey;

void LinkRule (rulekey)
	DefTableKey	rulekey;
{
SetNextRule (rulekey, rulechain, rulechain);
rulechain = rulekey;
}/* LinkRule */

DefTableKey FindEqualProd (rulekey, prod)
	DefTableKey	rulekey;
	TList		prod;
{	TList		ruleprod;
while (rulekey != NoKey) {
	ruleprod = GetRuleProd (rulekey, NullList);
	if (! (DifferentProds (prod, ruleprod)))
		return (rulekey);
	rulekey = GetNextRule (rulekey, NoKey);
}
return (NoKey);
}/* FindEqualProd */

DefTableKey FindNamedProd (prod, env, coord)
	TList		prod;
	Environment	env;
	POSITION *	coord;
{	DefTableKey	res, next;
	int		newid;

res = FindEqualProd (rulechain, prod);
if (res == NoKey) {
/* impossible since ligaprod and maptool generate named rules */
	newid = GenerateName ("rule_");
	res = Declare (env, newid, RuleDef, NoEnv, coord);
	SetRuleProd (res, prod, prod);
	LinkRule (res);
} else {
	/* reset coordinate to unnamed rule in original lido text: */
	SetCoord (res, coord, coord);
	/* no check for unique mapping of unnamed to named rules needed;
		done by ligaprod */
}
return (res);
}/* FindNamedProd */

TList FindNext (Did, Pro)
	int	Did;
	TList	Pro;
{	ProdElem	pel;
while (Pro != NullList) {
	pel = (ProdElem)HeadList (Pro);
	if ((pel->IsSymbol) && (pel->Id == Did)) return (Pro);
	Pro = TailList (Pro);
}
return (NullList);
}/*FindNext*/

int IsGenPos (Pro, Pos) TList Pro; int Pos;
{ ProdElem pel; int nextgen = 0;

while (Pro != NullList)
{
	pel = (ProdElem)HeadList (Pro);
	if (pel->IsSymbol)
	{
		if (Pos == pel->SyntPos &&
		    GetSymClass (pel->Key, SYMBTERM) == SYMBNONT)
		   return nextgen;
		nextgen = 0;
	} else nextgen = (pel->Id == SyntGenMark);
	Pro = TailList (Pro);
}
return 0;
}

int IsInProd (Key, Pro) DefTableKey Key; TList Pro;
{	ProdElem pel;
while (Pro != NullList) {
	pel = (ProdElem)HeadList (Pro);
	if ((pel->IsSymbol) && (pel->Key == Key))
		return 1;
	Pro = TailList (Pro);
}
return 0;
}/* IsInProd */

int FindSymPos (Key, Ind, Pro, Coord)
	DefTableKey	Key;
	int		Ind;
	TList		Pro;
	POSITION *	Coord;
{	ProdElem	pel;
	int Did;

Did = GetDid (Key, DIDNON);
Pro = FindNext (Did, Pro);	/* Pro is first occurrence of Did or nil */
if (Pro == NullList) {
	message (ERROR,MSGTXT( "Referenced symbol must be in production",
			      (lidoref)Attributes),
		0, Coord);
	return (0);
}
pel = (ProdElem)HeadList (Pro);

if (Ind == NoIndex) {
	Pro = FindNext (Did, TailList (Pro));
				/* Pro is 2nd occurrence of Did or nil */
	if (Pro != NullList) 
		message (ERROR,MSGTXT( "Symbol must be indexed",
				      (lidoref)Attributes), 0, Coord);
	return (pel->SyntPos);
} else if (Ind > 1) {
	Ind--;			/* Pro is ith occurrence of Did or nil */
				/* Ind = initial index - i */
	while ((Ind > 0) && (Pro != NullList)) {
		Pro = FindNext (Did, TailList (Pro));
		Ind--;
	}
	if (Pro == NullList)
		message (ERROR, 
		MSGTXT("Referenced symbol must be in production",
		       (lidoref)Attributes), 0, Coord);
		else	pel = (ProdElem)HeadList (Pro);
}
return (pel->SyntPos);
}/*FindSymPos*/

DefTableKey FindSymbOfRulePos (rule, symbno)
	DefTableKey rule; int symbno;
{ TList prod = GetRuleProd (rule, NullList);
  ProdElem pel;
  while (prod != NullList)
  { pel = (ProdElem)HeadList (prod);
    if (pel->IsSymbol && pel->SyntPos == symbno)
	return pel->Key;
    prod = TailList (prod);
  }
  return NoKey;
}/* FindSymbOfRulePos */

DefTableKey FindRuleForLhs (symb) DefTableKey symb;
{ DefTableKey rule = rulechain;
  TList prod;

  while (rule != NoKey)
  { prod = GetRuleProd (rule, NullList);
    if (prod != NullList && 
	(((ProdElem) HeadList (prod))->Key == symb))
	return rule;
    rule = GetNextRule (rule, NoKey);
  }
  return NoKey;
}/* FindRuleForLhs */

