

#include "PatternList.h"
#include "err.h"
#include "obstack.h"

typedef struct {
  Obstack space;
  void *baseptr;
} Dyn, *DynP;

static DynP PatternListSpace = (DynP)0;

#if defined(__STDC__) || defined(__cplusplus)
void FinlPatternList (void)
#else
void FinlPatternList ()
#endif
{
    if (PatternListSpace != (DynP)0)
    {  obstack_free(&(PatternListSpace->space), PatternListSpace->baseptr);
       PatternListSpace->baseptr = obstack_alloc(&(PatternListSpace->space), 0);
    }
}/* FinlPatternList */

#if defined(__STDC__) || defined(__cplusplus)
PatternList ConsPatternList (Pattern e, PatternList l)
#else
PatternList ConsPatternList (e, l)
        Pattern e;
        PatternList     l;
#endif
{
    PatternList h;

    if (PatternListSpace == (DynP)0)
    {   PatternListSpace = (DynP) malloc (sizeof(Dyn));
        if (PatternListSpace == (DynP)0)
        {  message (DEADLY, "no space for PatternList", 0, (POSITION*)0);
           exit (1);
        }
        obstack_init(&(PatternListSpace->space));
        PatternListSpace->baseptr =
                obstack_alloc(&(PatternListSpace->space), 0);
    }

    h = (PatternList)obstack_alloc(&(PatternListSpace->space),
                                  sizeof (struct _PatternLE));
    h->head = e;
    h->tail= l;
    return (h);
}/* ConsPatternList */

#if defined(__STDC__) || defined(__cplusplus)
Pattern HeadPatternList (PatternList l)
#else
Pattern HeadPatternList (l)
        PatternList     l;
#endif
{
    if (l == NULLPatternList)
    {
        message (DEADLY, "HeadPatternList: empty list", 0, (POSITION*)0);
        /* return ((Pattern)0); */
    } /* if */
    return (l->head);
}/* HeadPatternList */

#if defined(__STDC__) || defined(__cplusplus)
PatternList TailPatternList (PatternList l)
#else
PatternList TailPatternList (l)
        PatternList     l;
#endif
{
    return ((l==NULLPatternList) ? NULLPatternList : l->tail);
}/* TailPatternList */

#if defined(__STDC__) || defined(__cplusplus)
int LengthPatternList (PatternList l)
#else
int LengthPatternList (l)
        PatternList     l;
#endif
{
    int res = 0;

    for (; l; l = l->tail)
        res++;
    return (res);
}/* LengthPatternList */

#if defined(__STDC__) || defined(__cplusplus)
Pattern IthElemPatternList (PatternList l, int i)
#else
Pattern IthElemPatternList (l, i)
        PatternList     l;
        int     i;
#endif
{
    while ((i>1) && l)
    {
        i--;
        l = l->tail;
    }

    if ((i<=0) || (l==NULLPatternList))
        message (DEADLY, "IthElemPatternList: no such element",
                 0, (POSITION*)0);
    return (l->head);
}/* IthPatternList */


#if defined(__STDC__) || defined(__cplusplus)
PatternList CopyPatternList (PatternList l, PatternMapFct cp)
#else
PatternList CopyPatternList (l, cp)
        PatternList l;
        PatternMapFct   cp;
#endif
{
    PatternList NewList=NULLPatternList, *addr = &NewList;

    while (l)
    {
        (*addr) = ConsPatternList (cp (l->head), NULLPatternList);
        addr = &((*addr)->tail);
        l = l->tail;
    }
    return (NewList);
}/* CopyPatternList */

#if defined(__STDC__) || defined(__cplusplus)
PatternList AppPatternList (PatternList l1, PatternList l2)
#else
PatternList AppPatternList (l1, l2)
        PatternList     l1, l2;
#endif
{
    PatternList NewList;
    PatternList *addr = &NewList;

    if (!l1) return (l2);
    if (!l2) return (l1);

    while (l1) {
        (*addr) = ConsPatternList (l1->head, NULLPatternList);
        addr = &((*addr)->tail);
        l1 = l1->tail;
    }
    (*addr) = l2;

    return (NewList);
}/* AppPatternList */

#if defined(__STDC__) || defined(__cplusplus)
PatternList AppElPatternList (PatternList l, Pattern e)
#else
PatternList AppElPatternList (l, e)
        PatternList     l;
        Pattern e;
#endif
{
    PatternList res = l;
    if (!l)
        return (ConsPatternList (e, NULLPatternList));

    while (l->tail)
        l = l->tail;
    l->tail = ConsPatternList (e, NULLPatternList);

    return (res);
} /* AppElPatternList */


#if defined(__STDC__) || defined(__cplusplus)
void InsertAfterPatternList (PatternList l, Pattern e)
#else
void InsertAfterPatternList (l, e)
        PatternList     l;
        Pattern e;
#endif
{
    if (!l)
        message (DEADLY, "InserAfterPatternList: null list", 0, (POSITION*)0);
    else
        l->tail = ConsPatternList (e, l->tail);
}/* InsertAfterPatternList */

#if defined(__STDC__) || defined(__cplusplus)
PatternList OrderedInsertPatternList (PatternList l, Pattern e, PatternCmpFctType fcmp)
#else
PatternList OrderedInsertPatternList (l, e, fcmp)
        PatternList     l;
        Pattern e;
        PatternCmpFctType fcmp;
#endif
{
    PatternList p;
    if (!l)
        return (ConsPatternList (e, NULLPatternList));
    if (fcmp (e, l->head) <= 0)
        return (ConsPatternList (e, l));
    p = l;
    while (p->tail && (fcmp (e, p->tail->head) > 0))
        p = p->tail;
    p->tail = ConsPatternList (e, p->tail);
    return (l);
}/* OrderedInsertPatternList */

#if defined(__STDC__) || defined(__cplusplus)
PatternListPtr RefEndConsPatternList (PatternListPtr addr, Pattern e)
#else
PatternListPtr RefEndConsPatternList (addr, e)
        PatternListPtr  addr;
        Pattern         e;
#endif
{
    if (!addr)
    {
        message (DEADLY, "RefEndConsPatternList: no PatternList ref",
                 0, (POSITION*)0);
        return (addr);
    }
    (*addr) = ConsPatternList (e, NULLPatternList);
    return (&((*addr)->tail));
}/* RefEndConsPatternList */

#if defined(__STDC__) || defined(__cplusplus)
PatternListPtr RefEndAppPatternList (PatternListPtr addr, PatternList l)
#else
PatternListPtr RefEndAppPatternList (addr, l)
        PatternListPtr  addr;
        PatternList             l;
#endif
{
    if (!addr) {
        message (DEADLY, "RefEndAppPatternList: no PatternList ref",
                 0, (POSITION*)0);
        return (addr);
    }
    if (!l)
        return addr;

    (*addr) = l;

    while (l->tail)
        l = l->tail;
    return (&(l->tail));
}/* RefEndAppPatternList */

#if defined(__STDC__) || defined(__cplusplus)
int ElemInPatternList (Pattern e, PatternList l, PatternCmpFctType fcmp)
#else
int ElemInPatternList (e, l, fcmp)
        Pattern e;
        PatternList     l;
        PatternCmpFctType       fcmp;
#endif
{
    while (l != NULLPatternList) {
        if (fcmp (e, l->head) == 0)
            return (1);
        l = l->tail;
    }
    return (0);
}/* ElemInPatternList */

#if defined(__STDC__) || defined(__cplusplus)
PatternList AddToSetPatternList (Pattern e, PatternList l, PatternCmpFctType fcmp)
#else
PatternList AddToSetPatternList (e, l, fcmp)
        Pattern e;
        PatternList     l;
        PatternCmpFctType       fcmp;
#endif
{
    if (ElemInPatternList (e, l, fcmp))
        return (l);
    else
        return (ConsPatternList (e, l));
}/* AddToSetPatternList */


#if defined(__STDC__) || defined(__cplusplus)
PatternList AddToOrderedSetPatternList (Pattern e, PatternList l, PatternCmpFctType fcmp)
#else
PatternList AddToOrderedSetPatternList (e, l, fcmp)
        Pattern  e;
        PatternList      l;
        PatternCmpFctType fcmp;
#endif
{   int test;
    PatternList  p;
    if (!l)
        return (ConsPatternList (e, NULLPatternList));
    if ((test = fcmp (e, l->head)) < 0)
        return (ConsPatternList (e, l));
    if (test == 0) return l;
    p = l;
    while (p->tail && ((test = fcmp (e, p->tail->head)) > 0))
        p = p->tail;
    if (test) p->tail = ConsPatternList (e, p->tail);
    return (l);
}/* AddToOrderedSetPatternList */

#if defined(__STDC__) || defined(__cplusplus)
PatternList MapPatternList (PatternList l, PatternMapFct f)
#else
PatternList MapPatternList (l, f)
        PatternList     l;
        PatternMapFct f;
#endif
{
    PatternList NewList = NULLPatternList;
    PatternList last = NULLPatternList;

    while (l)
    {
        if (!NewList) {
            NewList = ConsPatternList ((f (l->head)), NULLPatternList);
            last = NewList;
        }
        else
        {
            last->tail = ConsPatternList ((f (l->head)), NULLPatternList);
            last = last->tail;
        }
        l = l->tail;
    }
    return (NewList);
}/* MapPatternList */

#if defined(__STDC__) || defined(__cplusplus)
int CompPatternList (PatternList l1, PatternList l2, PatternCmpFctType fcmp)
#else
int CompPatternList (l1, l2, fcmp)
        PatternList     l1, l2;
        PatternCmpFctType fcmp;
#endif
{
    int res = 0;
    while (l1 && l2 && (res == 0)) {
        res = (fcmp (l1->head, l2->head));
        l1 = l1->tail;
        l2 = l2->tail;
    }
    if (l1 && !l2)
        return (1);
    if (!l1 && l2)
        return (-1);
    return (res);
}/* CompPatternList */

#if defined(__STDC__) || defined(__cplusplus)
Pattern SumPatternList (PatternList l, PatternSumFct f, Pattern a)
#else
Pattern SumPatternList (l, f, a)
        PatternList     l;
        Pattern ((*f) ());
        Pattern a;
#endif
{
    while (l) {
        a = (f (a, l->head));
        l = l->tail;
    }
    return (a);
}/* SumPatternList */
