/* Copyright (C) 2004 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef SELECTED_ROWS_HANDLE_H
#define SELECTED_ROWS_HANDLE_H

#include "prog_defs.h"

#include <list>

#include <gtkmm/treepath.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treeview.h>
#include <glibmm/refptr.h>


#include "tree_model_row_reference.h"

typedef std::list<Gtk::TreeModel::Path> RowPathList;
typedef std::list<TreeModelRowReference> RowRefList;


class SelectedRowsHandle: public sigc::trackable {
  RowPathList path_list;
  void add(const Gtk::TreeModel::Path& path) {
    path_list.push_back(path);
  }
public:
  void fill(const Gtk::TreeView& tree_view);
  RowPathList::size_type size(void) const {return path_list.size();}
  bool is_empty(void) const {return path_list.empty();}

  // get_ref_list() should be called and the result stored before anything is done to
  // the tree view which invalidates the selected paths it provides (row references
  // are not invalidated by things done to the tree view, but paths can be)
  // this method will change the RowRefList argument - it will empty it of
  // any previous selection and then fill it with the current one
  void get_ref_list(Glib::RefPtr<Gtk::TreeModel>, RowRefList&) const;

  // the method front() can also be invalidated by things done to the tree
  // view as it returns a path. If the tree view might change use get_ref_list()
  // first and then call RowRefList::front()::get_path() with respect to that
  // list
  Gtk::TreeModel::Path front(void) const {return path_list.front();}

  SelectedRowsHandle() {}

  // if a Gtk::TreeView object is passed to the constructor, then the
  // path list will be filled immediately without the need to call
  // SelectedRowsHandle::fill()
  SelectedRowsHandle(const Gtk::TreeView& tree_view) {fill(tree_view);}
};

#endif
