/* Copyright (C) 2001 2002 2003 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "prog_defs.h"

#include <unistd.h>
#include <string>
#include <fstream>
#include <vector>
#include <list>
#include <utility>

#include <gtkmm/window.h>
#include <gtkmm/menubar.h>
#include <gtkmm/menuitem.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/box.h>
#include <gtkmm/entry.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/textview.h>
#include <gtkmm/label.h>
#include <gtkmm/frame.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/drawingarea.h>
#include <gtkmm/alignment.h>
#include <glibmm/ustring.h>
#include <glibmm/thread.h>
#include <sigc++/sigc++.h>

#include "efax_controller.h"
#include "fax_list_manager.h"
#include "fax_list.h"
#include "pipes.h"
#include "socket_server.h"
#include "socket_list.h"
#include "tray_icon.h"
#include "shared_ptr.h"
#include "helpfile.h"

#define MAINWIN_SAVE_FILE ".efax-gtk_mainwin_save"


class MessageText: public Gtk::ScrolledWindow {

  std::ofstream logfile;
  std::string logfile_name;
  std::string starting_dirname;
  Gtk::TextView text;
  Glib::RefPtr<Gtk::TextTag> red_tag_r;
  sigc::connection timer_slot_connection;
  void cleanify(std::string&);
public:
  void write_black_slot(const char* message);
  void write_red_slot(const char* message);
  bool flush_logfile_timer_slot(void);
  void reset_logfile(void);
  MessageText(void);
  ~MessageText(void);
};

class StatusLine: public Gtk::HBox {

  const int standard_size;
  Gtk::Label status_label;
  Gtk::Label help_label;
  Gtk::Frame status_frame;
  Gtk::Frame help_frame;
public:
  void set_status_line(const Glib::RefPtr<Gtk::Style>&, int);
  void write_status(const char* text) {status_label.set_text(text);}
  StatusLine(const int);
};

class MainWindow: public Gtk::Window {

  const int standard_size;
  static Pipe_fifo error_pipe;
  static bool connected_to_stderr;
  bool obscured;
  bool minimised;

  sigc::connection socket_dialog_connection;
  sigc::connection update_socket_list_connection;
  sigc::signal1<void, std::pair<Shared_ptr<FilenamesList>, Shared_ptr<Glib::Mutex::Lock> > > update_socket_list;
  sigc::signal0<void> close_socket_list_dialog;

  Gtk::DrawingArea drawing_area;
  Gtk::Alignment drawing_area_alignment;

  Gtk::VBox window_box;
  Gtk::Table file_entry_table;
  Gtk::Table win_table;
  Gtk::MenuBar menu_bar;
  Gtk::HBox fax_method_box;
  Gtk::HBox fax_method_radio_box;
  Gtk::HBox number_box;
  Gtk::Frame fax_method_radio_frame;
  Gtk::Frame file_entry_frame;
  Gtk::RadioButton file_button;
  Gtk::RadioButton socket_button;
  Gtk::Label fax_method_label;
  Gtk::Entry file_entry;
  Gtk::Entry number_entry;
  Gtk::Button single_file_button;
  Gtk::Button multiple_file_button;
  Gtk::Button socket_list_button;
  Gtk::Button number_button;
  Gtk::Button send_button;
  Gtk::Button receive_answer_button;
  Gtk::Button receive_takeover_button;
  Gtk::Button receive_standby_button;
  Gtk::Button stop_button;
  Glib::ustring max_text;
  MessageText text_window;
  StatusLine status_line;
  EfaxController efax_controller;
  Socket_server socket_server;

  Gtk::MenuItem* single_file_item_p;
  Gtk::MenuItem* multiple_file_item_p;
  Gtk::MenuItem* socket_list_item_p;

  std::pair<std::string, unsigned int> notified_fax;
  std::string selected_socket_list_file;

  FaxListDialog* received_fax_list_p;
  FaxListDialog* sent_fax_list_p;
  SocketListDialog* socket_list_p;
  HelpDialog* helpfile_p;

  TrayItem tray_item;

  void get_file_slot(void);
  void set_files_slot(const Glib::ustring&);
  void sendfax_slot(void);
  void receive_slot(EfaxController::State);
  void about_slot(bool);
  void fax_list_slot(FaxListEnum::Mode);
  void socket_list_slot(void);
  void socket_filelist_changed_notify_slot(void);
  void socket_filelist_closed_slot(void);
  void fax_to_send_notify_slot(void);
  void fax_to_send_dialog(const std::pair<std::string, unsigned int>&);
  void fax_received_notify_slot(void);
  void enter_socket_file_slot(const std::pair<Glib::ustring, std::string>&);
  void addressbook_slot(void);
  void file_list_slot(void);
  void settings_slot(void);
  void settings_changed_slot(const Glib::ustring&);
  void translations_slot(void);
  void helpfile_slot(void);
  void set_number_slot(const Glib::ustring&);
  bool read_error_slot(Glib::IOCondition);
  bool timer_event_handler(void);
  bool start_hidden_check_handler(void);
  void get_longest_button_text(void);
  void set_file_items_sensitive_slot(void);
  void set_socket_items_sensitive_slot(void);
  void tray_icon_left_clicked_slot(void);
  void tray_icon_menu_slot(int);
  bool draw_fax_from_socket_notifier(GdkEventExpose*);
  void get_window_settings(void);
  void save_window_settings(void);
  void strip(std::string&);
  void quit_slot(void);
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
  virtual void on_style_changed (const Glib::RefPtr<Gtk::Style>&);
  virtual bool on_visibility_notify_event(GdkEventVisibility*);
  virtual bool on_window_state_event(GdkEventWindowState*);
public:
  friend ssize_t write_error(const char*);
  friend int connect_to_stderr(void);

  void remove_from_socket_server_filelist(const std::string& file);
  void close_slot(void);
  MainWindow(const std::string&, bool start_hidden = false,
	     bool start_in_standby = false, const char* filename = 0);
  ~MainWindow(void);
};

#endif
