/* Copyright (C) 2001 to 2004 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef FAX_LIST_H
#define FAX_LIST_H

#include "prog_defs.h"

#include <string>
#include <utility>

#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>
#include <gtkmm/toolbar.h>
#include <gtkmm/box.h>
#include <gtkmm/paned.h>

#include <glibmm/ustring.h>

#if GTKMM_VERSION >= 24
#include <gtkmm/toolbutton.h>
#endif

#include "fax_list_manager.h"
#include "sem_sync.h"


// this class is modeless, and does not have an exec() method
// it is self-owning and will delete itself
class FaxListDialog: public Gtk::Window {
  FaxListEnum::Mode mode;
  static int is_fax_received_list;
  static int is_fax_sent_list;
  const int standard_size;

  Sem_sync fax_basename_sem;
  std::string fax_basename;

  FaxListManager fax_list_manager;

#if GTKMM_VERSION >= 24
  Gtk::ToolButton* print_button_p;
  Gtk::ToolButton* view_button_p;
  Gtk::ToolButton* describe_button_p;
  Gtk::ToolButton* delete_fax_button_p;
  Gtk::ToolButton* empty_trash_button_p;
  Gtk::ToolButton* delete_folder_button_p;
#else
  Gtk::Button* print_button_p;
  Gtk::Button* view_button_p;
  Gtk::Button* describe_button_p;
  Gtk::Button* delete_fax_button_p;
  Gtk::Button* empty_trash_button_p;
  Gtk::Button* delete_folder_button_p;
#endif

  Gtk::VBox fax_list_box;
  Gtk::Table table;
  Gtk::Toolbar tool_bar;
  Gtk::ScrolledWindow folder_list_scroll_window;
  Gtk::ScrolledWindow fax_list_scroll_window;
  Gtk::Button close_button;
  Gtk::HButtonBox button_box;
  Gtk::HPaned list_pane;

  void close_slot(void);
  void set_buttons_slot(void);
  void describe_fax_prompt(void);
  void delete_fax(void);
  void add_folder_prompt(void);
  void add_folder(const Glib::ustring&);
  void empty_trash_prompt(void);
  void delete_folder_prompt(void);
  void write_from_stdin(int);
  std::pair<const char*, char* const*> get_print_from_stdin_parms(void);
  std::pair<const char*, char* const*> get_fax_to_ps_parms(const std::string&, bool);
  std::pair<const char*, char* const*> get_ps_viewer_parms(const char*);
  void print_fax_prompt(void);
  void print_fax(void);
  void print_fax_thread(void);
  void view_fax(void);
  void view_fax_thread(void);
  void delete_parms(std::pair<const char*, char* const*>);
protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  static int get_is_fax_received_list(void) {return is_fax_received_list;}
  static int get_is_fax_sent_list(void) {return is_fax_sent_list;}

  void refresh_slot(void);
  FaxListDialog(FaxListEnum::Mode, const int standard_size_);
  ~FaxListDialog(void);
};

class EntryDialog: public Gtk::Window {

  bool in_exec_loop;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HButtonBox button_box;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Entry entry;
  Gtk::Window& parent;
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
public:
  void selected(bool);
  sigc::signal1<void, const Glib::ustring&> accepted;
  void exec(void);
  EntryDialog(const int standard_size, const Glib::ustring& entry_text,
	      const Glib::ustring& caption_text, const Glib::ustring& label_text,
	      Gtk::Window& window);
};


class DescriptionDialog: public EntryDialog {

public:
  DescriptionDialog(const int standard_size, const Glib::ustring& text, Gtk::Window& window);
};

class AddFolderDialog: public EntryDialog {

public:
  AddFolderDialog(const int standard_size, Gtk::Window& window);
};

#endif
