/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef DIALOGS_H
#define DIALOGS_H

#include "prog_defs.h"

#include <string>
#include <vector>
#include <utility>

#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/label.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/textview.h>
#include <gtkmm/messagedialog.h>
#include <glibmm/ustring.h>


#if GTKMM_VERSION >= 24
#include <gtkmm/filechooserdialog.h>
typedef Gtk::FileChooserDialog FileDialog;
#else
#include <gtkmm/fileselection.h>
typedef Gtk::FileSelection FileDialog;
#endif

class FileReadSelectDialog: public FileDialog {
  bool in_exec_loop;
  int standard_size;
  Gtk::Button view_button;
  Gtk::Window& parent;
  void selected(bool);
  std::vector<Glib::ustring> result;
  std::pair<const char*, char* const*> get_view_file_parms(void);
  void delete_parms(std::pair<const char*, char* const*>);
  // Gtk::FileChooser::get filename() incorrectly returns a Glib::ustring
  // object which have not been converted to UTF-8 and Gtk::FileChooser::get_filenames()
  // likewise incorrectly returns a container of Glib::ustrings.  We will therefore
  // provide our own methods for these (with gtkmm-2.0 and 2.2 these just hand over
  // from Gtk::FileSelection::get_filename() and Gtk::FileSelection::get_selections())
  std::string get_filename_string(void);
  std::vector<std::string> get_filenames_vec(void);
protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  void view_file(void);
  void finish(void);
  std::vector<Glib::ustring> exec(void);
  FileReadSelectDialog(int standard_size, bool multi_files, Gtk::Window& window);
};

class GplDialog;

class GplEditor: public Gtk::TextView {
  GplEditor(void) {} // private class
                     // only GplDialog can create an object
  friend class GplDialog;
};


class GplDialog: public Gtk::Window {
public:
  enum Result {rejected, accepted};
private:
  bool in_exec_loop;
  int standard_size;
  Result result;
  GplEditor editbox;
  Gtk::ScrolledWindow scrolled_window;
  Gtk::Button accept_button;
  Gtk::Button reject_button;
  Gtk::Label label;
  Gtk::Table table;
  Glib::ustring max_text;
  void selected(Result);
  void get_longest_button_text(void);
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
  virtual void on_style_changed (const Glib::RefPtr<Gtk::Style>&);
public:
  int exec(void);
  GplDialog(int standard_size);
};

class InfoDialog: public Gtk::MessageDialog {
  bool in_exec_loop;
  bool is_modal;
  Gtk::Window& parent;
  void selected(void);
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
public:
  void exec(void);
  InfoDialog(const Glib::ustring& text, const Glib::ustring& caption, int standard_size,
	     Gtk::MessageType message_type, Gtk::Window& window, bool modal = true);
};

class PromptDialog: public Gtk::Window {
  bool in_exec_loop;
  bool is_modal;
  bool result;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HButtonBox button_box;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Window& parent;
  void selected(bool);
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
public:
  sigc::signal0<void> accepted;
  sigc::signal0<void> rejected;
  bool exec(void);
  PromptDialog(const Glib::ustring& text, const Glib::ustring& caption,
	       int standard_size, Gtk::Window& window, bool modal = true);
};

#endif
