#include <list>
#include <string>

#include "ALogger.hh"
#include "TToken.hh"
#include "ITPushLexer.hh"
#include "APushParser.hh"
#include "TDictionary.hh"

ITPushLexer::ITPushLexer(ALogger& l, APushParser& p, TDictionary& d) : TPushLexer(l, p), dictionary(d)
{
  state = ACCEPT;
}

bool
ITPushLexer::complete()
{
  if (state == MACRO)
    {
      std::list<std::string> complete_list;
      std::string new_buffer = dictionary.complete(buffer, complete_list);

      if (!complete_list.size())
        {
          // no matching macro
          logger.warning("wrong prefix: nothing to complete");
        }
      else if (complete_list.size() == 1)
        {
          // good! we have found the macro
          buffer = new_buffer;
        }
      else
        {
          // we have more than one matching macro
          logger.warning("prefix not sufficient");
          buffer = new_buffer;
        }

      displayCursor();
      return true;
    }
  else return false;
}
