/*
 *  ---------
 * |.**> <**.|  CardContact
 * |*       *|  Software & System Consulting
 * |*       *|  Minden, Germany
 * |**> <**|  Copyright (c) 1999. All rights reserved
 *  --------- 
 *
 * See file LICENSE for details on licensing
 *
 * Abstract :       Defines tools/types for SDAP memory card handling
 *
 * Author :         Frank Thater (FTH)
 *
 * Last modified:   04/16/2000
 *
 *****************************************************************************/


#ifndef _MCSDAP_H_
#define _MCSDAP_H_

#include "memorycards.h"

#define PAGESIZE 256
#define I2C_CHAR 0xA0


int MC_SDAPInit(struct eco5000_t *ctx);

int MC_SDAPProcess(struct eco5000_t *ctx,
		  unsigned int lc,
		  unsigned char *cmd,
		  unsigned int *lr,
		  unsigned char *rsp);

int SDAP_Update_Binary(struct eco5000_t *ctx,
		      unsigned int lc,
		      unsigned char *cmd,
		      unsigned int *lr,
		      unsigned char *rsp);

int SDAP_Read_Card(struct eco5000_t *ctx, 
		   unsigned int soffset, 
		   int length);

#endif


