/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright 2002-2004 Todd Kulesza
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 */

#ifndef _DRIVEL_H_
#define _DRIVEL_H_

#include "config.h"
#include "drivel_request.h"
#include "egg-recent.h"
#include "utils.h"

#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs.h>
#include <gconf/gconf-client.h>
#include <curl/curl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>

typedef struct _DrivelClient DrivelClient;
typedef struct _DrivelNet DrivelNet;
typedef struct _DrivelGConfData DrivelGConfData;
typedef struct _DrivelIDs DrivelIDs;
typedef struct _DrivelTime DrivelTime;
typedef struct _LJMenuItem LJMenuItem;
typedef struct _LJFriend LJFriend;
typedef struct _DrivelButtonVAList DrivelButtonVAList;

struct _LJFriend
{
	gchar *name;
	gchar *username;
	gchar *bg;
	gchar *fg;
	gint type;
	guint groupmask;
	gboolean friend;
	gboolean friend_of;
};

enum
{
	FRIEND_TYPE_USER,
	FRIEND_TYPE_COMMUNITY,
	FRIEND_TYPE_FEED
};

struct _LJMenuItem
{
	gchar *label;
	gchar *url;
	gushort menu_index;
	gushort item_index;
	gushort sub_menu;
};

struct _DrivelTime
{
	gint year;
	gint month;
	gint day;
	gint hour;
	gint minute;
};

struct _DrivelButtonVAList
{
	GtkWidget *button;
	GSList *entries;
	GSList *signals;
};

struct _DrivelIDs
{
	/* gconf ids */
	guint server_list_id;
	guint server_id;
	guint mood_id;
	guint music_id;
	guint picture_id;
	guint security_id;
	guint comment_id;
	guint autoformat_id;
	guint proxy_id;
	guint proxy_url_id;
	guint proxy_port_id;
	guint proxy_user_id;
	guint proxy_pass_id;
	guint tray_id;
	guint highlight_syntax_id;
	guint spellcheck_id;
	
	/* loop ids */
	guint loop_checkfriends_id;
};

struct _DrivelGConfData
{
	/* login window preferences */
	gchar *user;
	gchar *password;
	gchar *save_password;
	gchar *autologin;
	
	/* journal window default preferences */
	gchar *default_server_list;
	gchar *default_server;
	gchar *default_mood;
	gchar *default_music;
	gchar *default_picture;
	gchar *default_security;
	gchar *default_comment;
	gchar *default_autoformat;
	gchar *expander_open;
	
	/* proxy preferencess */
	gchar *proxy;
	gchar *proxy_url;
	gchar *proxy_port;
	gchar *proxy_user;
	gchar *proxy_pass;
	
	/* notification area preferences */
	gchar *tray;
	
	/* entry position and size */
	gchar *entry_x;
	gchar *entry_y;
	gchar *entry_height;
	gchar *entry_width;
	gchar *entry_max;
	gchar *min_start;
	gchar *min_post;
	gchar *highlight_syntax;
	gchar *spellcheck;
};

struct _DrivelNet
{
	DrivelBlogAPI api;
	gchar *server;
	CURLSH *curl_share;
	gint fast_servers;
	GAsyncQueue *msg_queue;
	GnomeVFSCancellation *cancel;
};

struct _DrivelClient
{
	GtkWidget *login_window;
	GtkWidget *journal_window;
	GtkWidget *current_window;
	GtkWidget *friends_list_window;
	GtkWidget *edit_history_window;

	/* location of the configuration directory */
	gchar *config_directory;
	
	/* login window widgets */
	GtkWidget *login_name;
	GtkWidget *login_password;
	GtkWidget *save_password;
	GtkWidget *autologin;
	GtkWidget *login_button;
	GtkWidget *login_menu;
	GtkWidget *sign_up_button;
	GtkWidget *sign_up_menu;
	
	/* journal window widgets */
	GtkWidget *journal_subject;
	GtkWidget *journal_mood;
	GtkWidget *journal_music;
	GtkWidget *journal_text;
	GtkWidget *journal_security;
	GtkWidget *journal_picture;
	GtkWidget *journal_comment;
	GtkWidget *journal_autoformat;
	GtkWidget *journal_backdate;
	GtkWidget *journal_date;
	GtkWidget *options_frame;
	GtkTextBuffer *buffer;
	GtkWidget *preferences_mood;
	GtkWidget *journal_post;
	GtkWidget *journal_options;
	GtkWidget *edit_delete;
	GtkWidget *edit_save;
	GtkWidget *edit_cancel;
	GtkWidget *menu_post;
	GtkWidget *menu_update;
	GtkWidget *menu_delete;
	GtkWidget *menu_undo;
	GtkWidget *menu_redo;
	GtkWidget *menu_cut;
	GtkWidget *menu_copy;
	GtkWidget *menu_paste;
	EggRecentModel *recent_model;
	EggRecentViewGtk *recent_view;
	
	/* preferences widgets */
	GtkWidget *pref_server_list;
	GtkWidget *pref_server;
	GtkWidget *pref_server_label;
	
	/* friends dialog */
	GtkListStore *list_store;
	GtkWidget *friend_list;
	GtkWidget *friend_edit;
	GtkWidget *friend_remove;
	GtkWidget *friends_username;
	GtkWidget *friends_fg_colour;
	GtkWidget *friends_bg_colour;
	GtkWidget *friends_type_icon;
	GtkWidget *friends_type_name;
	GtkWidget *dialog_add_friend;
	GtkWidget *dialog_add_fg;
	GtkWidget *dialog_add_bg;
	GtkWidget *dialog_add_ok;
	
	/* history dialog */
	GtkListStore *history_store;
	GtkWidget *history_list;
	GtkWidget *history_calendar;
	GtkWidget *history_edit;
	
	/* insert link dialog */
	GtkWidget *link_text;
	GtkWidget *link_text_label;
	GtkWidget *link_url;
	GtkWidget *link_url_label;
	GtkWidget *link_url_example;
	GtkWidget *link_user;
	GtkWidget *link_user_label;
	GtkWidget *link_ok;
	DrivelButtonVAList *link_bval;
	
	/* insert image dialog */
	GtkWidget *image_url;
	GtkWidget *image_height;
	GtkWidget *image_width;
	GtkWidget *image_alt;
	GtkWidget *image_ok;
	DrivelButtonVAList *image_bval;
	
	GtkWidget *message_dialog;
	GtkWidget *open_dialog;
	GtkWidget *save_dialog;
	GtkWidget *network_progress;
	
	/* network data */
	DrivelNet *net;
	gchar *proxy_proper_format;
	guint tag_autosave;
	gint time_since_checkfriends;
	gchar *lastupdate;
	gboolean checking_friends;
	gboolean friends_update;
	
	GConfClient *client;
	DrivelGConfData *gconf;
	
	/* user-specific settings */
	gchar *name;
	gchar *username;
	gchar *password;
	gboolean use_fast_servers;
	GHashTable *picture_keywords;
	GHashTable *picture_filenames;
	gchar *default_picture_file;
	GHashTable *mood_icons;
	GSList *mood_list;
	gint pictures;
	gint moods;
	gint journals;
	GSList *journal_list;
	gchar *active_journal;
	gchar *itemid;
	gboolean modified;
	gboolean modified_autosave;
	gint response;
	gboolean proxy;
	gchar *proxy_user;
	gchar *proxy_pass;
	gchar *proxy_url;
	gint proxy_port;
	GSList *menu_list;
	GSList *friends_list;
	gchar *login_send_data;
	gboolean invalid_input;
	gboolean edit_entry;
	GSList *window_list;
	gboolean tray;
	GtkListStore *picture_store;
	gchar *draft_filename;
	
	DrivelTime time;
	DrivelIDs id;
};

void
display_error_dialog (DrivelClient *dc, const gchar *header, const gchar *mesg);

void
fill_time (DrivelClient *dc);

void
drivel_button_list_clear (DrivelButtonVAList *bval);

void
drivel_push_current_window (DrivelClient *dc, GtkWidget *window);

GtkWidget *
drivel_pop_current_window (DrivelClient *dc);

GtkWidget *
drivel_get_current_window (GSList *list);

void
drivel_gconf_data_fill (DrivelGConfData *data, const gchar *username, GConfClient *client, DrivelIDs *id, DrivelClient *dc);

void
drivel_fill_journal_null (DrivelClient *dc);

gboolean
validate_username (const gchar *username);

gchar *
get_default_text (GConfClient *client, const gchar *key, const gchar *standard_text);

void
list_free_item (gpointer data, gpointer user_data);

void
menu_list_free_item (gpointer data, gpointer user_data);

void
friends_list_free_item (gpointer data, gpointer user_data);

gint
compare_usernames (gconstpointer a, gconstpointer b);

void
fill_picture_menu (DrivelClient *dc, GtkListStore *picture_store);

#endif
