/* doscan - Denial Of Service Capable Auditing of Networks
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PROTO_H
#define PROTO_H

#include "subnets.h"

struct scan_host_t;             /* from scan.h */

typedef bool (*proto_start_t) (subnets&);
/* Called when a protocol engine is chosen for scanning. */

typedef void (*proto_open_t) (struct scan_host_t *);
/* Called to open a host connection. */

void proto_register (const char *, proto_start_t, proto_open_t);
/* Register a protocol handler.  Auto-generated code calls this
   routine. */

void proto_select (const char *);
/* Selects a protocol for scanning. */

void proto_register_all (void);
/* Triggers protocol registration. */

bool proto_start (subnets&);
/* Calls the protocol-specific start routine. */

void proto_open (struct scan_host_t *);
/* Calls the protocol-specific open routine. */

#endif /* PROTO_H */

/* arch-tag: 586569c1-97d0-432f-b077-6b09f58c65f9
 */
